package com.priusis.service.common;

import com.priusis.client.service.MqttRpcDataMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Slf4j
@Component
public class MacAddrService {

    private static String macAddr;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 获取MAC地址
     */
    public void initMacAddr(String macAddr) {
        this.macAddr = macAddr;
    }

    /**
     * 获取MAC地址
     */
    public String getMacAddr() {
        try {
            if (null == macAddr) {
                // 获取采集到的硬件信息
                ResponseEntity<MqttRpcDataMessage> forEntity = null;
                try {
                    forEntity = restTemplate.getForEntity("http://localhost:8765/rpc_cmd/mac_addr", MqttRpcDataMessage.class);
                    if (null != forEntity) {
                        MqttRpcDataMessage body = forEntity.getBody();
                        macAddr = body.getParams();
                    }
                } catch (Exception e) {
                    log.error("采集数据异常", e);
                }
            }
            if (null == macAddr) {
                /*try {
                    macAddr = MacAddrUtil.getSigarMac();
                    MqttRpcDataMessage mqttRpcDataMessage = MqttRpcDataMessage.builder()
                            .sendTime(System.currentTimeMillis())
                            .method("mac_addr")
                            .params(macAddr).build();
                    restTemplate.postForObject("http://localhost:8765/rpc_cmd", mqttRpcDataMessage, String.class);
                } catch (Exception e) {
                    log.error("采集数据异常", e);
                }*/
                throw new RuntimeException("macAddr is null");
            }
        } catch (RestClientException e) {
            log.error("macAddr异常");
        }
        return macAddr;
    }
}
