package com.priusis.utils;


import com.priusis.exception.ServiceException;
import com.zy.QrDecode.CQrDecode;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class QrCodeUtils {
    static int[] result = new int[4];

    public static QrCode qrCodeUt(String qrString) {
        String path = CQrDecode.parseAbsolutePath("/qr/dat/0000000d.dat", "smart-property/0000000d.dat");
        CQrDecode cQrDecode = new CQrDecode();
        int i = cQrDecode.ZOOYAPI_GetCodeII(path, qrString, result);
        log.info("二维码解码状态:{}, datPath:{}", i, path);
        switch (i) {
            case 0:
                QrCode qrCode = new QrCode();
                qrCode.setCard(Integer.toHexString(result[0]));
                qrCode.setCheckCode(Integer.toString(result[1]));
                return qrCode;
            case 4001:
                throw new ServiceException("key file path error or not exist");
            case 4003:
                throw new ServiceException("key file open fail");
            case 4005:
                throw new ServiceException("qr-code is not match current key file");
            default:
                return null;
        }
    }

}
