package com.priusis.client.util.converter.transformer;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class BaseDataValueTransformer extends AbstractDataValueTransformer {

    static final String INT_TO_DOUBLE_TRANSFORMER_NAME = "intToDouble";

    private static final int MAX_DOUBLE_VALUE = 65536;
    private static final int DIVIDE_POWER = 10;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Double transformToDouble(String strValue) {
        Double value = Double.valueOf(strValue);
        if (value <= MAX_DOUBLE_VALUE) {
            return value / DIVIDE_POWER;
        } else {
            return (MAX_DOUBLE_VALUE - value) / DIVIDE_POWER;
        }
    }

    @Override
    public Long transformToLong(String strValue) {
        return Long.valueOf(strValue);
    }

    @Override
    public String transformToString(String strValue) {
        return strValue;
    }

    @Override
    public String transformToJson(String strValue) {
        //return toJsonStr(strValue);
        return strValue;
    }

    @Override
    public Boolean transformToBoolean(String strValue) {
        return Boolean.valueOf(strValue);
    }

    private String toJsonStr(String value) throws JsonProcessingException {
        return mapper.writeValueAsString(value);
    }
}

