package com.priusis.controller;

import com.priusis.lib.R;
import com.priusis.util.SysConfigUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * @author yangli
 * @since 2021/09/10
 */
@Validated
@RestController
@RequestMapping(value = "config")
public class ConfigController {

    @GetMapping(value = "get_download_path")
    public R<String> getDownloadPath() throws IOException {
        String path = SysConfigUtil.getProperty("download.path",
                System.getProperty("user.home") + File.separator + "Downloads");
        return R.success(path);
    }

    @PostMapping(value = "save_download_path")
    public R<Void> saveDownloadPath(@RequestBody Map<String, String> params) throws IOException {
        String path = params.get("path");
        SysConfigUtil.saveProperty("download.path", path);
        return R.success();
    }


}
