package com.priusis.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.priusis.dto.FacilityPropertyPCAddDto;
import com.priusis.lib.R;
import com.priusis.service.common.MacAddrService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Objects;

/**
 * 设备资产信息
 *
 * @author yanghan
 * @date 2022/1/10 11:06
 */
@Slf4j
@RestController
@RequestMapping("/property")
@Validated
public class FacilityPropertyController {

    @Value(value = "${apq.iot-gateway}")
    private String gateway;

    @Value(value = "${apq.url.facility-property-update}")
    private String facilityPropertyUpdateUrl;

    @Value(value = "${apq.url.facility-property-view}")  // facility/property?macAddress={}
    private String facilityPropertyViewUrl;

    @Value(value = "${apq.client.tenantId}")
    private Long tenantId;

    @Autowired
    private MacAddrService macAddrService;

    @PostMapping("/upd")
    public R pcUpdFacility(@RequestBody @Valid FacilityPropertyPCAddDto dto) {
        String reqUrl = gateway + StrUtil.format(facilityPropertyUpdateUrl);
        dto.setMacAddress(macAddrService.getMacAddr());
        dto.setTenantId(tenantId);
        String result = HttpUtil.post(reqUrl, JSONUtil.toJsonStr(dto));
        JSONObject jsonObject = JSONUtil.parseObj(result);
        if (!Objects.equals(jsonObject.get("code"), 0)) {
            log.error("设备资产维护异常,{}", jsonObject.get("msg"));
            return R.error();
        }
        return R.success();
    }

    @GetMapping("info")
    public R info() {
        String reqUrl = gateway + StrUtil.format(facilityPropertyViewUrl, macAddrService.getMacAddr());
        String resultData = HttpUtil.get(reqUrl, 3000);
        JSONObject data = JSONUtil.parseObj(resultData, true);
        JSONObject data1 = data.getJSONObject("data");
        if (null != data1 && data1.size() > 0) {
            return R.success(data1);
        }
        return R.success();
    }


}
