package com.priusis.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.priusis.cache.InstalledProgramCache;
import com.priusis.lib.R;
import com.priusis.service.common.MacAddrService;
import com.priusis.utils.SysConfigUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author yangli
 * @since 2021/09/07
 */
@Slf4j
@Validated
@RestController
@RequestMapping(value = "program")
public class ProgramController {
    @Value(value = "${apq.iot-gateway}")
    private String gateway;

    @Value(value = "${apq.url.install}")
    private String installUrl;

    @Value(value = "${apq.url.upgrade}")
    private String upgradeUrl;

    @Value(value = "${apq.url.install-status-upissue}")
    private String installStatusUpIssueUrl;

    @Value(value = "${apq.url.upgrade-status-upissue}")
    private String upgradeStatusUpIssueUrl;

    @Value(value = "${apq.url.add-program}")
    private String addProgramUrl;

    private List<String> excludePrograms = ListUtil.of("svchost.exe", "explorer.exe", "dwm.exe"
            , "apq-client.exe"
            , "alg.exe"
            , "csrss.exe"
            , "ctfmon.exe"
            , "lsass.exe"
            , "nvvsvc.exe"
            , "services.exe"
            , "smss.exe"
            , "winlogon.exe"
            , "mstask.exe"
            , "winmgmt.exe"
            , "conhost.exe"
            , "sihost.exe"
            , "dllhost.exe"
            , "smartscreen.exe"
            , "SearchUI.exe"
            , "igfxEM.exe"
            , "Taskmgr.exe"
            , "fontdrvhost.exe"
            , "wscript.exe"
            , "taskhostw.exe"
            , "StartMenuExperienceHost.exe"
            , "ShellExperienceHost.exe"
            , "SettingSyncHost.exe"
            , "RuntimeBroker.exe"
            , "igfxext.exe"
            , "ApplicationFrameHost.exe"
            , "LockApp.exe"
            , "Microsoft.Photos.exe"
    );

    @Resource
    private InstalledProgramCache installedProgramCache;

    @Autowired
    private MacAddrService macAddrService;

    private static final double MIN_MATCH = 0.5;

    @GetMapping(value = "{type}/list")
    public R<Page<Map<String, String>>> list(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                             @RequestParam(required = false, defaultValue = "1") Integer current,
                                             @RequestParam(required = false, defaultValue = "10") Integer size) {
        try {
            String mac = macAddrService.getMacAddr();
            if (StrUtil.isBlank(mac)) return R.error("未获取到MAC地址");
            String url = gateway + StrUtil.format(type.equals("install") ? installUrl : upgradeUrl, mac, current, size);
            JSONObject rsp = JSONUtil.parseObj(HttpUtil.get(url));
            if (ObjectUtil.notEqual(rsp.getInt("code"), 0)) return R.error(rsp.getStr("msg"));
            Page<Map<String, String>> page = new Page<>();
            page.setCurrent(current).setSize(size).setTotal(rsp.getLong("total"));
            JSONArray rows = rsp.getJSONArray("rows");
            if (CollUtil.isEmpty(rows)) return R.success(page.setRecords(Collections.emptyList()));
            List<Map<String, String>> programs = installedProgramCache.getPrograms();
            List<Map<String, String>> list = rows.stream().map(JSONObject.class::cast)
                    .map(o -> {
                        Map<String, String> map = new HashMap<>();
                        map.put("id", o.getStr(type.equals("install") ? "installId" : "upgradeId"));
                        map.put("name", StrUtil.subBefore(o.getStr("fileName"), '.', true));
                        map.put("size", o.getStr("fileSize"));
                        map.put("version", o.getStr("version"));
                        map.put("isUpgrade", o.getBool("isUpgrade", true).toString());
                        map.put("localVersion", null);
                        map.put("url", o.getStr("url"));
                        Long id = Convert.toLong(map.get("id"));
                        String key = type + "-" + id;
                        map.put("status", SET.contains(key) ? "1" : MAP.containsKey(key) ? "2" : "0");
                        return map;
                    })
                    /*.peek(m -> */
                    .peek(m -> {
                        if (type.equals("install")) {
                            programs.stream()
                                    .filter(p -> p.get("name").equalsIgnoreCase(m.get("name")))
                                    .findFirst()
                                    .ifPresent(p -> m.put("localVersion", p.get("version")));
                        } else {
                            programs.stream()
                                    .collect(Collectors.toMap(p -> StrUtil.similar(p.get("name").toLowerCase(), m.get("name").toLowerCase()),
                                            p -> p.getOrDefault("version", ""), (l, r) -> r))
                                    .entrySet()
                                    .stream()
                                    .max(Map.Entry.comparingByKey())
                                    .filter(e -> e.getKey() >= MIN_MATCH)
                                    .filter(e -> StrUtil.isNotBlank(e.getValue()))
                                    .ifPresent(e -> m.put("localVersion", e.getValue()));
                        }
                    })
                    .collect(Collectors.toList());
            return R.success(page.setRecords(list));
        } catch (Exception e) {
            log.error("客户端系统异常", e);
            return R.error("客户端正在初始化，请稍后再试!");
        }
    }

    private static final Set<String> SET = new ConcurrentHashSet<>();
    private static final Map<String, Thread> MAP = new ConcurrentHashMap<>();


    @GetMapping(value = "test_install")
    public void test() {
        int exitVal = -1;
        try {
            Runtime.getRuntime().exec("cmd /c \"D:\\work\\priusis\\priusis-iot\\apq-iot\\apq-client\\tools\\install-package\\boot\\dist\\阿普奇采集程序.exe\"");
        } catch (Exception e) {
            log.error("执行安装文件失败", e);
        }
        System.out.println(exitVal);
    }

    /**
     * https://blog.csdn.net/n_fly/article/details/79672455
     * https://www.jb51.net/article/82757.htm
     * <p>
     * A.exe是系统权限,它在session 0,而B.exe他是session1.当A程序运行在session0,也就是系统服务窗口，所以你当前桌面上是看不到的。这种情况你需要用CreateProcessAsUser()API等方式模拟当前登陆用户方式
     *
     * @param type
     * @param id
     * @param url
     * @param response
     * @throws IOException
     */
    @GetMapping(value = "{type}/download_and_install")
    public void downloadAndInstall(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                   @RequestParam @NotNull Long id,
                                   @RequestParam @NotBlank String url,
                                   HttpServletResponse response) throws IOException {
        File dir = new File(SysConfigUtil.getProperty("download.path",
                System.getProperty("user.dir").substring(0, 3) + "apqdownloads"));
        if (!dir.exists()) dir.mkdirs();
        HttpResponse rsp = HttpUtil.createGet(url).execute(true);
        double length = rsp.contentLength();
        DecimalFormat decimalFormat = new DecimalFormat("0.#####");
        String key = type + "-" + id;
        File file = rsp.writeBodyForFile(dir, new StreamProgress() {
            @SneakyThrows
            @Override
            public void start() {
                SET.add(key);
                response.getWriter().write("0\n");
            }

            @SneakyThrows
            @Override
            public void progress(long progressSize) {
                response.getWriter().write(decimalFormat.format(progressSize / length) + "\n");
            }

            @SneakyThrows
            @Override
            public void finish() {
                response.getWriter().close();
                SET.remove(key);
            }
        });
        /*MAP.put(key, new Thread(() -> {
            int exitVal = -1;
            try {
                exitVal = Runtime.getRuntime().exec("cmd /c \"" + file.getPath() + "\"").waitFor();
            } catch (Exception e) {
                log.error("执行安装文件 {} 失败", file.getPath(), e);
            }
            MAP.remove(key);
            if (exitVal == 0) {
                String reqUrl = gateway + StrUtil.format(type.equals("install") ? installStatusUpIssueUrl : upgradeStatusUpIssueUrl,
                        macAddrService.getMacAddr(), id);
                HttpUtil.post(reqUrl, (String) null);
            }
        }));
        MAP.get(key).start();*/
        DOWNLOAD_PATH_MAP.put(key, file.getPath().replace('\\', '/'));
    }

/*    @GetMapping(value = "{type}/is_installing")
    public R<Boolean> isInstalling(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                   @RequestParam @NotNull Long id) {
        return R.success(MAP.containsKey(type + "-" + id));
    }*/

    private static final Map<String, String> DOWNLOAD_PATH_MAP = new ConcurrentHashMap<>();

    @GetMapping(value = "{type}/get_download_path")
    public R<String> getDownloadPath(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                     @RequestParam @NotNull Long id) {
        return R.success(DOWNLOAD_PATH_MAP.get(type + "-" + id));
    }


    @GetMapping(value = "{type}/install_success")
    public R<Void> installSuccess(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                  @RequestParam @NotNull Long id) {
        String reqUrl = gateway + StrUtil.format(type.equals("install") ? installStatusUpIssueUrl : upgradeStatusUpIssueUrl,
                macAddrService.getMacAddr(), id);
        HttpUtil.post(reqUrl, (String) null);
        return R.success();
    }

    @GetMapping(value = "{type}/get_version")
    public R<String> getVersion(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                @RequestParam @NotBlank String name) throws IOException {
        // 查最新版本之前，手动清掉缓存，重新扫一遍
        installedProgramCache.clearProgramInfoCache();
        installedProgramCache.loadProgramListJob();
        return type.equals("install") ?
                installedProgramCache.getPrograms().stream()
                        .filter(p -> p.get("name").equalsIgnoreCase(name))
                        .findFirst()
                        .map(m -> m.get("version"))
                        .map(R::success)
                        .orElseGet(R::success) :
                installedProgramCache.getPrograms().stream()
                        .collect(Collectors.toMap(p -> StrUtil.similar(p.get("name").toLowerCase(), name.toLowerCase()),
                                p -> p.getOrDefault("version", ""), (l, r) -> r))
                        .entrySet()
                        .stream()
                        .max(Map.Entry.comparingByKey())
                        .filter(e -> e.getKey() >= MIN_MATCH)
                        .filter(e -> StrUtil.isNotBlank(e.getValue()))
                        .map(Map.Entry::getValue)
                        .map(R::success)
                        .orElseGet(R::success);
    }

    @GetMapping(value = "get_exe_path")
    public R<String> getVersion(@RequestParam @NotBlank String name) throws IOException {
        if (null == installedProgramCache || null == installedProgramCache.getPrograms()) {
            return R.success();
        }
        return installedProgramCache.getPrograms().stream()
                .filter(p -> p.get("name").equalsIgnoreCase(name))
                .findFirst()
                .map(m -> m.get("path"))
                .map(R::success)
                .orElseGet(R::success);
    }
}
