package com.priusis.utils;

import cn.hutool.core.util.StrUtil;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import lombok.extern.slf4j.Slf4j;

import java.awt.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

@Slf4j
public class WinExecuteUtils {

    /**
     * @desc 启动进程
     * @author zp
     * @date 2018-3-29
     */
    public static void startProc(String processName) {
        log.info("启动应用程序：" + processName);
        if (StrUtil.isNotBlank(processName)) {
            try {
                Desktop.getDesktop().open(new File(processName));
            } catch (Exception e) {
                e.printStackTrace();
                log.error("应用程序：" + processName + "不存在！");
            }
        }
    }

    /**
     * 调用windows - api CreateProcessAsUser 启动
     *
     * @param lpCommandLine
     */
    public static void startProcAsUser(String lpCommandLine) {
        log.info("调用windows - api CreateProcessAsUser 启动=================1");
        // https://github.com/murrayju/CreateProcessAsUser/blob/master/ProcessExtensions/ProcessExtensions.cs

        // get impersonation token of user
        WinNT.HANDLEByReference threadToken = new WinNT.HANDLEByReference();
        WinNT.HANDLE threadHandle = Kernel32.INSTANCE.GetCurrentThread();

        boolean threadTokenResult = Advapi32.INSTANCE.OpenThreadToken(
                threadHandle,
                WinNT.TOKEN_QUERY | WinNT.TOKEN_DUPLICATE | WinNT.TOKEN_ASSIGN_PRIMARY,
                false, /* TRUE if the access check is to be made against the process-level security context. FALSE if the access check is to be made against the current security context of the thread calling the OpenThreadToken function. */
                threadToken);

        log.info("调用windows - api CreateProcessAsUser 启动=================2, threadToken:{}, result:{}", threadToken.getValue(), threadTokenResult);
        // create primary token by duplicating impersonation token
        WinNT.HANDLEByReference primaryToken = new WinNT.HANDLEByReference();

        boolean primaryTokenResult = Advapi32.INSTANCE.DuplicateTokenEx(
                threadToken.getValue(),                                     /* hExistingToken */
                WinNT.TOKEN_DUPLICATE | WinNT.TOKEN_QUERY | WinNT.TOKEN_ASSIGN_PRIMARY, /* dwDesiredAccess */
                null,                                           /* lpTokenAttributes */
                WinNT.SECURITY_IMPERSONATION_LEVEL.SecurityDelegation,      /* ImpersonationLevel */
                WinNT.TOKEN_TYPE.TokenPrimary,                              /* TokenType */
                primaryToken);                                              /* phNewToken */

        // String environment = createEnvironment(primaryToken);

        log.info("调用windows - api CreateProcessAsUser 启动=================3, primaryToken:{}, result:{}", primaryToken.getValue(), primaryTokenResult);
        WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
        WinBase.PROCESS_INFORMATION processInfo = new WinBase.PROCESS_INFORMATION();

        //BOOL CreateProcessAsUser（
        //HANDLE hToken，//处理表示登录用户的标记
        //LPCTSTR lpApplicationName，//指向可执行模块名称的指针
        //LPTSTR lpCommandLine，//指向命令行字符串的指针
        //LPSECURITY_ATTRIBUTES lpProcessAttributes，//处理安全属性
        //LPSECURITY_ATTRIBUTES lpThreadAttributes， //线程安全属性
        //BOOL bInheritHandles，//新进程是否继承处理
        //DWORD dwCreationFlags，//创建标志
        //LPVOID lpEnvironment，//指向新环境块的
        //指针LPCTSTR lpCurrentDirectory，//指向当前目录名称的
        //指针LPSTARTUPINFO lpStartupInfo，//指向STARTUPINFO的指针
        //LPPROCESS_INFORMATION lpProcessInformation //指向PROCESS_INFORMATION的指针
        //）;
        boolean createProcessResult = Advapi32.INSTANCE.CreateProcessAsUser(
                primaryToken.getValue(),    /* hToken */
                null,           /* lpApplicationName */
                lpCommandLine,                    /* lpCommandLine */
                null,       /* lpProcessAttributes */
                null,           /* lpThreadAttributes */
                false,          /* bInheritHandles */
                WinNT.CREATE_NEW_CONSOLE | WinNT.CREATE_UNICODE_ENVIRONMENT, /* dwCreationFlags */
                null,                /* lpEnvironment */
                null,           /* lpCurrentDirectory */
                startupInfo,                /* lpStartupInfo */
                processInfo);               /* lpProcessInformation */
        log.info("调用windows - api CreateProcessAsUser 启动=================4, result:{}", createProcessResult);
    }

    /**
     * @throws IOException
     * @desc 杀死进程
     * @author zp
     * @date 2018-3-29
     */
    public static void killProc(String processName) throws IOException {
        log.info("关闭应用程序：" + processName);
        if (StrUtil.isNotBlank(processName)) {
            executeCmd("taskkill /F /IM " + processName);
        }
    }

    /**
     * @desc 执行cmd命令
     * @author zp
     * @date 2018-3-29
     */
    public static String executeCmd(String command) throws IOException {
        log.info("Execute command : " + command);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("cmd /c " + command);
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBk"));
        String line = null;
        StringBuilder build = new StringBuilder();
        while ((line = br.readLine()) != null) {
            log.info(line);
            build.append(line);
        }
        return build.toString();
    }

    /**
     * @desc 执行exe命令
     * @author zp
     * @date 2018-3-29
     */
    public static String executeExe(String command) throws IOException {
        log.info("Execute command : " + command);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
        String line = null;
        StringBuilder build = new StringBuilder();
        while ((line = br.readLine()) != null) {
            log.info(line);
            build.append(line);
        }
        return build.toString();
    }

    /**
     * @desc 判断进程是否开启
     * @author zp
     * @date 2018-3-29
     */
    public static boolean findProcess(String processName) {
        BufferedReader bufferedReader = null;
        try {
            Process proc = Runtime.getRuntime().exec("tasklist -fi " + '"' + "imagename eq " + processName + '"');
            bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains(processName)) {
                    return true;
                }
            }
            return false;
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        } finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (Exception ex) {
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {

        // get impersonation token of user
//        WinExecuteUtils.executeExe("C:\\windows\\notepad.exe D:\\info.log");
//        WinExecuteUtils.executeExe("D:\\360\\360sd\\360sd.exe C:\\WINDOWS");
//        WinExecuteUtils.startProcAsUser("C:\\windows\\notepad.exe D:\\info.log");
        WinExecuteUtils.startProcAsUser("D:\\360\\360sd\\360sd.exe C:\\WINDOWS");
//         WinExecuteUtils.startProcAsUser("D:\\360\\360sd\\360sd.exe");

        /*String procName = "Postman.exe";
        boolean exist = findProcess(procName);
        try {
            if (exist) {
                // 存在，那么就先杀死该进程
                killProc(procName);
                // 再启动
                startProc(procName);
            } else {
                startProc(procName);
            }
        } catch (Exception e) {
            // TODO: handle exception
            log.error("重启/杀死提取程序失败。。。");
        }*/
    }

}
