package com.priusis.utils.sigar;

import org.hyperic.sigar.*;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * 获取系统网络信息
 */
public class SigarGetIo {

    public long getTotalByte() {
        Sigar sigar = new Sigar();
        long totalByte = 0;
        try {
            FileSystem[] fslist = sigar.getFileSystemList();
            for (int i = 0; i < fslist.length; i++) {
                if (fslist[i].getType() == 2) {
                    FileSystemUsage usage = sigar.getFileSystemUsage(fslist[i].getDirName());
                    totalByte += usage.getDiskReadBytes();
                    totalByte += usage.getDiskWriteBytes();
                }
            }
        } catch (SigarException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return totalByte;
    }

    public static void main(String[] args) {
        SigarGetIo io = new SigarGetIo();
        long tempTotal = io.getTotalByte();
        for (int i = 0; i < 200; i++) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            long total = io.getTotalByte();
            System.out.println(Integer.valueOf((int) ((total - tempTotal) / 1000)) + "kb");
            tempTotal = total;
        }
    }

}
