package com.priusis.utils.sigar;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

import cn.hutool.core.util.NumberUtil;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

/**
 * 获取系统网络信息
 */
public class SigarGetNet {

    public static void main(String[] args) throws SigarException, InterruptedException {

        Sigar sigar = new Sigar();

        while (true) {
            sigarNetInfo(sigar);
            Thread.sleep(1500);
        }

        // 关闭sigar
//        sigar.close();
    }

    private static void sigarNetInfo(Sigar sigar) throws SigarException, InterruptedException {
        String ip = "";
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (!name.contains("docker") && !name.contains("lo")) {
                    for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (!inetAddress.isLoopbackAddress()) {
                            String ipaddress = inetAddress.getHostAddress();
                            if (!ipaddress.contains("::") && !ipaddress.contains("0:0:") && !ipaddress.contains("fe80")) {
                                ip = ipaddress;
                            }
                        }
                    }
                }
            }
        } catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }

        String[] netInterfaceList = sigar.getNetInterfaceList();

        double rxBytes = 0;
        double txBytes = 0;
        String description = null;
        // 一些其它的信息
        for (int i = 0; i < netInterfaceList.length; i++) {
            String netInterface = netInterfaceList[i];// 网络接口
            NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(netInterface);

            if (netInterfaceConfig.getAddress().equals(ip)) {

                description = netInterfaceConfig.getDescription();

                System.out.println("网卡描述信息 =======" + description);
                double start = System.currentTimeMillis();
                NetInterfaceStat statStart = sigar.getNetInterfaceStat(netInterface);
                double rxBytesStart = statStart.getRxBytes();
                double txBytesStart = statStart.getTxBytes();

                Thread.sleep(1000);
                double end = System.currentTimeMillis();
                NetInterfaceStat statEnd = sigar.getNetInterfaceStat(netInterface);
                double rxBytesEnd = statEnd.getRxBytes();
                double txBytesEnd = statEnd.getTxBytes();

                rxBytes = ((rxBytesEnd - rxBytesStart) * 8 / (end - start) * 1000) / 1024;
                txBytes = ((txBytesEnd - txBytesStart) * 8 / (end - start) * 1000) / 1024;

                break;
            }

            // 判断网卡信息中是否包含VMware即虚拟机，不存在则设置为返回值
            //System.out.println("网卡MAC地址 ======="+netInterfaceConfig.getHwaddr());

        }
//        // 接收字节
//        String rxBytess;
//        // 发送字节
//        String txBytess;
//
//        if (rxBytes > 1024) {
//            rxBytess = String.format("%.1f", rxBytes / 1024) + " Mbps";
//        } else {
//            rxBytess = String.format("%.0f", rxBytes) + " Kbps";
//        }
//        if (txBytes > 1024) {
//            txBytess = String.format("%.1f", txBytes / 1024) + " Mbps";
//        } else {
//            txBytess = String.format("%.0f", txBytes) + " Kbps";
//        }

        rxBytes = NumberUtil.round(rxBytes, 2).doubleValue();
        txBytes = NumberUtil.round(txBytes, 2).doubleValue();

//        System.out.println("发送=======" + rxBytess);
//        System.out.println("接收=======" + txBytess);
//
        System.out.println("发送=======" + rxBytes);
        System.out.println("接收=======" + txBytes);
        System.out.println("IP=======" + ip);

    }

}
