package com.priusis.vo;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * @author xls
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FacilityProgramVo implements Serializable, Comparable<FacilityProgramVo> {
    /**
     * 设备id
     */
    private Long facilityId;
    /**
     * 程序名称
     */
    private String programName;
    /**
     * 是否系统软件：0否 1是
     */
    private Integer programType;
    /**
     * 软件安装路径
     */
    private String programPath;

    public static FacilityProgramVo toFacilityProgramVoFromCache(Map<String, String> installProgram) {
        FacilityProgramVo facilityProgramVo = new FacilityProgramVo();
        String name = installProgram.get("name");
        String publisher = installProgram.get("publisher");// Microsoft Corporation
        facilityProgramVo.setProgramName(name);
        facilityProgramVo.setProgramPath(installProgram.get("path"));
        facilityProgramVo.setProgramType((StrUtil.equals("Microsoft Corporation", publisher)
                && (name.startsWith("Microsoft Visual C++")
                || name.startsWith("Microsoft Visual Studio")
                || name.startsWith("Microsoft .NET")
                || name.startsWith("Universal CRT")
                || name.startsWith("WinRT Intellisense")
                || name.startsWith("Windows ")
        )) ? 1 : 0);

        return facilityProgramVo;
    }

    public static FacilityProgramVo toFacilityProgramVoFromProcessName(String processName) {
        FacilityProgramVo facilityProgramVo = new FacilityProgramVo();
        facilityProgramVo.setProgramName(processName);
        facilityProgramVo.setProgramType(0);
        return facilityProgramVo;
    }

    @Override
    public int compareTo(FacilityProgramVo o) {
        return programName.compareTo(o.programName);
    }
}
