package com.priusis.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.priusis.cache.InstalledProgramCache;
import com.priusis.lib.R;
import com.priusis.service.common.MacAddrService;
import com.priusis.utils.ProcessExtensionsApqUtil;
import com.priusis.utils.SysConfigUtil;
import com.priusis.vo.FacilityProgramVo;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author yangli
 * @since 2021/09/07
 */
@Slf4j
@Validated
@RestController
@RequestMapping(value = "program")
public class ProgramController {
    @Value(value = "${apq.iot-gateway}")
    private String gateway;

    @Value(value = "${apq.url.install}")
    private String installUrl;

    @Value(value = "${apq.url.upgrade}")
    private String upgradeUrl;

    @Value(value = "${apq.url.install-status-upissue}")
    private String installStatusUpIssueUrl;

    @Value(value = "${apq.url.upgrade-status-upissue}")
    private String upgradeStatusUpIssueUrl;

    @Value(value = "${apq.url.add-program}")
    private String addProgramUrl;

    private List<String> excludePrograms = ListUtil.of("svchost.exe", "explorer.exe", "dwm.exe"
            , "apq-client.exe"
            , "alg.exe"
            , "csrss.exe"
            , "ctfmon.exe"
            , "lsass.exe"
            , "nvvsvc.exe"
            , "services.exe"
            , "smss.exe"
            , "winlogon.exe"
            , "mstask.exe"
            , "winmgmt.exe"
            , "conhost.exe"
            , "sihost.exe"
            , "dllhost.exe"
            , "smartscreen.exe"
            , "SearchUI.exe"
            , "igfxEM.exe"
            , "Taskmgr.exe"
            , "fontdrvhost.exe"
            , "wscript.exe"
            , "taskhostw.exe"
            , "StartMenuExperienceHost.exe"
            , "ShellExperienceHost.exe"
            , "SettingSyncHost.exe"
            , "RuntimeBroker.exe"
            , "igfxext.exe"
            , "ApplicationFrameHost.exe"
            , "LockApp.exe"
            , "Microsoft.Photos.exe"
    );

    @Resource
    private InstalledProgramCache installedProgramCache;

    @Autowired
    private MacAddrService macAddrService;

    private static final double MIN_MATCH = 0.5;

    @GetMapping(value = "{type}/list")
    public R<Page<Map<String, String>>> list(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                             @RequestParam(required = false, defaultValue = "1") Integer current,
                                             @RequestParam(required = false, defaultValue = "10") Integer size) {
        try {
            String mac = macAddrService.getMacAddr();
            if (StrUtil.isBlank(mac)) return R.error("未获取到MAC地址");
            String url = gateway + StrUtil.format(type.equals("install") ? installUrl : upgradeUrl, mac, current, size);
            JSONObject rsp = JSONUtil.parseObj(HttpUtil.get(url));
            if (ObjectUtil.notEqual(rsp.getInt("code"), 0)) return R.error(rsp.getStr("msg"));
            Page<Map<String, String>> page = new Page<>();
            page.setCurrent(current).setSize(size).setTotal(rsp.getLong("total"));
            JSONArray rows = rsp.getJSONArray("rows");
            if (CollUtil.isEmpty(rows)) return R.success(page.setRecords(Collections.emptyList()));
            List<Map<String, String>> programs = installedProgramCache.getPrograms();
            List<Map<String, String>> list = rows.stream().map(JSONObject.class::cast)
                    .map(o -> {
                        Map<String, String> map = new HashMap<>();
                        map.put("id", o.getStr(type.equals("install") ? "installId" : "upgradeId"));
                        map.put("name", StrUtil.subBefore(o.getStr("fileName"), '.', true));
                        map.put("size", o.getStr("fileSize"));
                        map.put("version", o.getStr("version"));
                        map.put("isUpgrade", o.getBool("isUpgrade", true).toString());
                        map.put("localVersion", null);
                        map.put("url", o.getStr("url"));
                        Long id = Convert.toLong(map.get("id"));
                        String key = type + "-" + id;
                        map.put("status", SET.contains(key) ? "1" : MAP.containsKey(key) ? "2" : "0");
                        return map;
                    })
                    /*.peek(m -> */
                    .peek(m -> {
                        if (type.equals("install")) {
                            programs.stream()
                                    .filter(p -> p.get("name").equalsIgnoreCase(m.get("name")))
                                    .findFirst()
                                    .ifPresent(p -> m.put("localVersion", p.get("version")));
                        } else {
                            programs.stream()
                                    .collect(Collectors.toMap(p -> StrUtil.similar(p.get("name").toLowerCase(), m.get("name").toLowerCase()),
                                            p -> p.getOrDefault("version", ""), (l, r) -> r))
                                    .entrySet()
                                    .stream()
                                    .max(Map.Entry.comparingByKey())
                                    .filter(e -> e.getKey() >= MIN_MATCH)
                                    .filter(e -> StrUtil.isNotBlank(e.getValue()))
                                    .ifPresent(e -> m.put("localVersion", e.getValue()));
                        }
                    })
                    .collect(Collectors.toList());
            return R.success(page.setRecords(list));
        } catch (Exception e) {
            log.error("客户端系统异常", e);
            return R.error("客户端正在初始化，请稍后再试!");
        }
    }

    private static final Set<String> SET = new ConcurrentHashSet<>();
    private static final Map<String, Thread> MAP = new ConcurrentHashMap<>();


    @GetMapping(value = "test_install")
    public void test() {
        int exitVal = -1;
        try {
            Runtime.getRuntime().exec("cmd /c \"D:\\work\\priusis\\priusis-iot\\apq-iot\\apq-client\\tools\\install-package\\boot\\dist\\阿普奇采集程序.exe\"");
        } catch (Exception e) {
            log.error("执行安装文件失败", e);
        }
        System.out.println(exitVal);
    }

    /**
     * https://blog.csdn.net/n_fly/article/details/79672455
     * https://www.jb51.net/article/82757.htm
     * <p>
     * A.exe是系统权限,它在session 0,而B.exe他是session1.当A程序运行在session0,也就是系统服务窗口，所以你当前桌面上是看不到的。这种情况你需要用CreateProcessAsUser()API等方式模拟当前登陆用户方式
     *
     * @param type
     * @param id
     * @param url
     * @param response
     * @throws IOException
     */
    @GetMapping(value = "{type}/download_and_install")
    public void downloadAndInstall(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                   @RequestParam @NotNull Long id,
                                   @RequestParam @NotBlank String url,
                                   HttpServletResponse response) throws IOException {
        File dir = new File(SysConfigUtil.getProperty("download.path",
                System.getProperty("user.dir").substring(0, 3) + "apqdownloads"));
        if (!dir.exists()) dir.mkdirs();
        HttpResponse rsp = HttpUtil.createGet(url).execute(true);
        double length = rsp.contentLength();
        DecimalFormat decimalFormat = new DecimalFormat("0.#####");
        String key = type + "-" + id;
        File file = rsp.writeBodyForFile(dir, new StreamProgress() {
            @SneakyThrows
            @Override
            public void start() {
                SET.add(key);
                response.getWriter().write("0\n");
            }

            @SneakyThrows
            @Override
            public void progress(long progressSize) {
                response.getWriter().write(decimalFormat.format(progressSize / length) + "\n");
            }

            @SneakyThrows
            @Override
            public void finish() {
                response.getWriter().close();
                SET.remove(key);
            }
        });
        /*MAP.put(key, new Thread(() -> {
            int exitVal = -1;
            try {
                exitVal = Runtime.getRuntime().exec("cmd /c \"" + file.getPath() + "\"").waitFor();
            } catch (Exception e) {
                log.error("执行安装文件 {} 失败", file.getPath(), e);
            }
            MAP.remove(key);
            if (exitVal == 0) {
                String reqUrl = gateway + StrUtil.format(type.equals("install") ? installStatusUpIssueUrl : upgradeStatusUpIssueUrl,
                        macAddrService.getMacAddr(), id);
                HttpUtil.post(reqUrl, (String) null);
            }
        }));
        MAP.get(key).start();*/
        DOWNLOAD_PATH_MAP.put(key, file.getPath().replace('\\', '/'));
    }

/*    @GetMapping(value = "{type}/is_installing")
    public R<Boolean> isInstalling(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                   @RequestParam @NotNull Long id) {
        return R.success(MAP.containsKey(type + "-" + id));
    }*/

    private static final Map<String, String> DOWNLOAD_PATH_MAP = new ConcurrentHashMap<>();

    @GetMapping(value = "{type}/get_download_path")
    public R<String> getDownloadPath(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                     @RequestParam @NotNull Long id) {
        return R.success(DOWNLOAD_PATH_MAP.get(type + "-" + id));
    }


    @GetMapping(value = "{type}/install_success")
    public R<Void> installSuccess(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                  @RequestParam @NotNull Long id) {
        String reqUrl = gateway + StrUtil.format(type.equals("install") ? installStatusUpIssueUrl : upgradeStatusUpIssueUrl,
                macAddrService.getMacAddr(), id);
        HttpUtil.post(reqUrl, (String) null);
        return R.success();
    }

    @GetMapping(value = "{type}/get_version")
    public R<String> getVersion(@PathVariable @Pattern(regexp = "install|upgrade") String type,
                                @RequestParam @NotBlank String name) throws IOException {
        // 查最新版本之前，手动清掉缓存，重新扫一遍
        installedProgramCache.clearProgramInfoCache();
        installedProgramCache.loadProgramListJob();
        return type.equals("install") ?
                installedProgramCache.getPrograms().stream()
                        .filter(p -> p.get("name").equalsIgnoreCase(name))
                        .findFirst()
                        .map(m -> m.get("version"))
                        .map(R::success)
                        .orElseGet(R::success) :
                installedProgramCache.getPrograms().stream()
                        .collect(Collectors.toMap(p -> StrUtil.similar(p.get("name").toLowerCase(), name.toLowerCase()),
                                p -> p.getOrDefault("version", ""), (l, r) -> r))
                        .entrySet()
                        .stream()
                        .max(Map.Entry.comparingByKey())
                        .filter(e -> e.getKey() >= MIN_MATCH)
                        .filter(e -> StrUtil.isNotBlank(e.getValue()))
                        .map(Map.Entry::getValue)
                        .map(R::success)
                        .orElseGet(R::success);
    }

    @GetMapping(value = "get_exe_path")
    public R<String> getVersion(@RequestParam @NotBlank String name) throws IOException {
        if (null == installedProgramCache || null == installedProgramCache.getPrograms()) {
            return R.success();
        }
        return installedProgramCache.getPrograms().stream()
                .filter(p -> p.get("name").equalsIgnoreCase(name))
                .findFirst()
                .map(m -> m.get("path"))
                .map(R::success)
                .orElseGet(R::success);
    }


    //// @Scheduled(fixedDelay = 60000)
    public void addProgram2Platform(String bizRequestId) throws IOException {
        String mac = macAddrService.getMacAddr();
        if (StrUtil.isBlank(mac)) {
            log.warn("未获取到MAC地址");
            return;
        }
        // 已安装软件列表
        List<FacilityProgramVo> programNames = installedProgramCache.getPrograms()
                .stream().map(FacilityProgramVo::toFacilityProgramVoFromCache).sorted().collect(Collectors.toList());
        log.info("收到平台扫描软件请求，已安装软件：{}", programNames.size());
        // 扫描进程列表
        Set<String> processNames = new HashSet<>();
        Process process = Runtime.getRuntime().exec("cmd /c tasklist"
                + " -fi " + '"' + "USERNAME ne NT AUTHORITY\\NETWORK SERVICE" + '"'
                + " -fi " + '"' + "USERNAME ne NT AUTHORITY\\LOCAL SERVICE" + '"'
                + " -fi " + '"' + "USERNAME ne Window Manager\\UMFD-0" + '"'
                + " -fi " + '"' + "USERNAME ne Font Driver Host\\UMFD-1" + '"'
                + " -fi " + '"' + "USERNAME ne Font Driver Host\\DWM-1" + '"'
                + " -fi " + '"' + "USERNAME ne 暂缺" + '"'
                + " /fo csv");

        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"))) {
            reader.readLine();
            String line;
            while ((line = reader.readLine()) != null) {
                // 去除注册表的数据
                String taskProcess = line.substring(1, line.indexOf("\",\""));
                if (!containsOfCache(taskProcess) && !excludePrograms.contains(taskProcess)) {
                    processNames.add(taskProcess);
                }
            }
            process.destroy();
        }

        List<FacilityProgramVo> processNameVos = Lists.newArrayList();
        for (String processName : processNames) {
            processNameVos.add(FacilityProgramVo.toFacilityProgramVoFromProcessName(processName));
        }
        log.info("收到平台扫描软件请求，扫描进程列表：{}", processNameVos.size());
        String postResult = HttpUtil.post(gateway + addProgramUrl,
                JSONUtil.createObj()
                        .set("macAddress", mac)
                        .set("requestId", bizRequestId)
                        .set("programList", programNames)
                        .set("processList", processNameVos)
                        .toString());
        log.info("设备软件扫描,result:{},requestId:{},programList:{},processList:{}", postResult, bizRequestId, programNames.size(), processNameVos.size());
    }

    private boolean containsOfCache(String taskProcess) {
        boolean result = false;
        try {
            for (Map<String, String> program : installedProgramCache.getPrograms()) {
                String startPath = MapUtil.getStr(program, "startPath");
                if (!StrUtil.isBlank(startPath) && startPath.contains("." + taskProcess)) {
                    result = true;
                    continue;
                }
            }
        } catch (Exception e) {
            log.error("系统异常", e);
        }

        return result;
    }


    public static void main(String[] args) throws InterruptedException, IOException {
        String t = "{\"changeContent\":\"拔出U盘/移动硬盘\",\"changeRemark\":\"USB 大容量存储设备;;Storage Media;兼容 USB 存储设备;class\u003dUSB;\",\"changeType\":2,\"deviceClass\":\"USB_DRIVE\"}";

        System.out.println(t);
        /*int exitVal = -1;
        try {
            exitVal = Runtime.getRuntime().exec("cmd /c \"D:\\work\\priusis\\priusis-iot\\apq-iot\\apq-client\\tools\\install-package\boot\\dist\\apq-info-install.exe\"").waitFor();
        } catch (Exception e) {
            log.error("执行安装文件失败", e);
        }
        System.out.println(exitVal);
        System.out.println("========");*/

//        System.out.println("cmd /c tasklist -fi " + '"' + "imagename ne NT AUTHORITY SYSTEM" + '"' + " -fi " + '"' + "imagename ne NT AUTHORITY SYSTEM" + '"' + " /fo csv");

/*        int exitVal = -1;
        try {
            exitVal = Runtime.getRuntime().exec("cmd /c \"D:\\work\\priusis\\priusis-iot\\apq-iot\\apq-client\\tools\\install-package\\boot\\dist\\阿普奇检测客户端_x32.exe\" /sp- /silent /norestart /suppressmsgboxes").waitFor();
        } catch (Exception e) {
            log.error("执行安装文件失败", e);
        }
        System.out.println(exitVal);*/

        // =================================================================

        /*String url = "http://apuqi.oss-cn-zhangjiakou.aliyuncs.com/ossdata/20220420/f65fe478633c43f493a0b60d13717504.exe";
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        System.out.println(fileName);

        Runtime.getRuntime().exec("cmd /c \"C:\\apqdownloads\\f65fe478633c43f493a0b60d13717504.exe\"");
        System.out.println(11);*/
    }

    @Scheduled(fixedDelay = 360000)
    protected void autoUpgradeJob() {
        try {
            log.info("执行自动安装文件 ==============1");
            boolean autoUpgrade = Convert.toBool(SysConfigUtil.getProperty("auto.upgrade"), true);
            if (!autoUpgrade) return;
            String downloadPath = SysConfigUtil.getProperty("download.path",
                    System.getProperty("user.dir").substring(0, 3) + "apqdownloads");
            File dir = new File(downloadPath);
            if (!dir.exists()) dir.mkdirs();
            log.info("执行自动安装文件 ==============2");
            list("upgrade", 1, 10000).getData().getRecords()
                    .parallelStream()
                    // upgradeTime
                    .filter(m -> BooleanUtil.toBoolean(m.get("isUpgrade")) && ObjectUtil.notEqual(m.get("version"), m.get("localVersion")))
                    .forEach(m -> {
                        log.info("执行自动安装文件 ==============3");
                        String url = m.get("url");
                        String fileName = url.substring(url.lastIndexOf("/") + 1);
                        File fileE = new File(downloadPath + File.separator + fileName);
                        if (!fileE.exists()) {
                            HttpResponse rsp = HttpUtil.createGet(url).execute(true);
                            fileE = rsp.writeBodyForFile(dir, null);
                        }

//                        int exitVal = -1;
                        try {
                            String exeCmd = "autoExe.bat \"" + fileE.getPath() + "\"";
                            ProcessExtensionsApqUtil.apq_CreateProcessAsUser(exeCmd);
                            log.info("执行安装文件 {} ", exeCmd);
//                                Runtime.getRuntime().exec("cmd /c \"C:\\apqdownloads\\f65fe478633c43f493a0b60d13717504.exe\" /sp- /silent /norestart /suppressmsgboxes");
                            installedProgramCache.updateProgramInfoCacheByNameAndVersion(m.get("name"), m.get("version"));
                        } catch (Exception e) {
                            log.error("执行安装文件 {} 失败", fileE.getPath(), e);
                        }
                        log.info("执行安装文件 ==============");
//                        if (exitVal == 0) {
//                            String reqUrl = gateway + StrUtil.format(upgradeStatusUpIssueUrl, macAddrService.getMacAddr(), m.get("id"));
//                            HttpUtil.post(reqUrl, (String) null);
//                        }
                    });
        } catch (Exception e) {
            log.error("自动升级任务执行异常", e);
        }
    }

}
