package com.priusis.utils;

import cn.hutool.system.oshi.OshiUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;

import java.util.Arrays;


/**
 * Java通过JNA调用CoreTemp.dll实现温度采集   方式1
 * https://github.com/boyang987/BLHWScaner
 */
public class CoreTemp1Util {

    static final String coreFromOs = "CoreTemp" + (OshiUtil.getOs().getBitness() == 64 ? "x64" : "");
    static final String WR0_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/" + coreFromOs + ".dll", System.getProperty("user.dir") + "/apq-pc-common");
    static CoreTemp WR0_INSTANCE = Native.loadLibrary(WR0_DLL_NAME, CoreTemp.class);

    /**
     * 获取cpu温度
     *
     * @return
     */
    public static boolean GetCpuTemp(IntByReference cpuCoreNum, int[] cpuTemp) {
        return WR0_INSTANCE.GetCpuTemp(cpuCoreNum, cpuTemp);
    }

    /**
     * 获取gpu温度
     *
     * @return
     */
    public static boolean GetGpuTemp(IntByReference pSensorNum, int[] gpuTemp) {
        return WR0_INSTANCE.GetGpuTemp(pSensorNum, gpuTemp);
    }

    /**
     * CPU温度
     */
    public static int getCpuTemp() throws Exception {
        IntByReference cpuCoreNum = new IntByReference(0);
        int[] cpuTemp = new int[64];
        CoreTemp1Util.GetCpuTemp(cpuCoreNum, cpuTemp);
        return Arrays.stream(cpuTemp).max().getAsInt();
    }

    /**
     * GPU温度
     */
    public static int getGpuTemp() throws Exception {
        IntByReference pSensorNum = new IntByReference(0);
        int[] gpuTemp = new int[64];
        CoreTemp1Util.GetGpuTemp(pSensorNum, gpuTemp);

        return Arrays.stream(gpuTemp).max().getAsInt();
    }

    /**
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {
//        while (true) {

        IntByReference cpuCoreNum = new IntByReference(0);
        int[] cpuTemp = new int[64];
        //WinRing0初始化
        CoreTemp1Util.GetCpuTemp(cpuCoreNum, cpuTemp);
//            int value = cpuCoreNum.getValue();
//            System.out.println(value);
//            for (int i = 0; i < value; i++) {
//                System.out.println(cpuTemp[i]);
//            }

        IntByReference pSensorNum = new IntByReference(0);
        int[] gpuTemp = new int[64];
        CoreTemp1Util.GetGpuTemp(pSensorNum, gpuTemp);

        System.out.println("CPU温度:" + Arrays.stream(cpuTemp).max().getAsInt()); // cpu温度
        System.out.println("GPU温度:" + Arrays.stream(gpuTemp).max().getAsInt()); // gpu温度

        System.out.println("===============================");
//            Thread.sleep(1500);
//        }
    }

    private interface CoreTemp extends Library {
        // 声明将要调用的DLL中的方法
        boolean GetCpuTemp(IntByReference cpuCoreNum, int[] cpuTemp);

        boolean GetGpuTemp(IntByReference pSensorNum, int[] gpuTemp);
    }

}
