package com.priusis.utils;

import lombok.extern.slf4j.Slf4j;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author yangli
 * @since 2021/09/28
 */
@Slf4j
public final class MacAddrUtil {

    public static String getSigarMac() {
        Sigar sigar = new Sigar();
        String[] ifaces = null;
        try {
            ifaces = sigar.getNetInterfaceList();

            for (int i = 0; i < ifaces.length; i++) {
                NetInterfaceConfig cfg = sigar.getNetInterfaceConfig(ifaces[i]);
                if (NetFlags.LOOPBACK_ADDRESS.equals(cfg.getAddress()) || (cfg.getFlags() & NetFlags.IFF_LOOPBACK) != 0
                        || NetFlags.NULL_HWADDR.equals(cfg.getHwaddr()) || NetFlags.ANY_ADDR.equals(cfg.getAddress())) {
                    continue;
                }
                return cfg.getHwaddr();
            }
        } catch (SigarException e) {
            log.error("SigarException", e);
        }
        return null;
    }

    public static String getAllMacAddress() {
        Set<String> macSet = new HashSet<>();
        byte[] mac = null;

        try {
            //获取所有的网络接口
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                //遍历每一个网络接口
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                //若是网路接口是：1回环接口 2虚拟网口 3网口状态为unUser，则跳过
                if (netInterface.isLoopback() || netInterface.isVirtual()/* || !netInterface.isUp()*/) {
                    continue;
                } else {
                    String macAppend = "";
                    mac = netInterface.getHardwareAddress();
                    if (mac != null) {
                        for (int i = 0; i < mac.length; i++) {
                            macAppend += String.format("%02X%s", mac[i], (i < mac.length - 1) ? ":" : "");
                        }
                        macSet.add(macAppend);
                    }
                }
            }
        } catch (Exception e) {
            log.error("IP地址获取失败", e);
        }

        if (macSet.size() > 0) {
            return macSet.stream().collect(Collectors.joining(","));
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println("本机MAC:" + getAllMacAddress());
        System.out.println(MacAddrUtil.getSigarMac());
    }
}
