package com.priusis.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.oshi.OshiUtil;
import lombok.extern.slf4j.Slf4j;
import org.hyperic.sigar.SigarException;
import oshi.hardware.HWDiskStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
public class Oshi4NoneSigarUtil {
    static String baseboard;
    static String diskStoresModel;
    static String os;

    public static String getBaseboardWithCache() {
        if (null == baseboard) {
            baseboard = OshiUtil.getSystem().getBaseboard().getManufacturer() + " " + OshiUtil.getSystem().getBaseboard().getVersion();
        }
        return baseboard;
    }

    public static String getOsWithCache() {
        if (null == os) {
            OperatingSystem ost = OshiUtil.getOs();
            os = ost.getManufacturer() + " " + ost.getFamily() + " " + ost.getVersionInfo().getVersion() + "(" + ost.getBitness() + ")";
        }
        return os;
    }

    public static String getDiskStoresModelFromOshi() {
        try {
            HWDiskStore[] diskStoresFromOshi = OshiUtil.getHardware().getDiskStores();
            // ADATA_IMSS314-128GM(128GB/固态硬盘)
            Map<String, String> diskInfoFromSmartMap = DiskSmartUtil.getDiskInfoFromSmart();
            diskStoresModel = Arrays.stream(diskStoresFromOshi)
                    .map(diskStoreFromOshi -> StrUtil.removeSuffix(StrUtil.removeSuffix(diskStoreFromOshi.getModel(), " (标准磁盘驱动器)"), " (Standard disk drives)")
                            + "("
                            + FormatUtil.formatBytesDecimal(diskStoreFromOshi.getSize())
                            + diskTypeFromSmart(diskInfoFromSmartMap, StrUtil.removeSuffix(StrUtil.removeSuffix(diskStoreFromOshi.getModel(), " (标准磁盘驱动器)"), " (Standard disk drives)"))
                            + ")")
                    .collect(Collectors.joining(","));
        } catch (Exception e) {
            log.error("硬盘型号数据获取失败", e);
        }
        return diskStoresModel;
    }

    public static String getDiskStoresModelJsonFromOshi() {
        try {
            HWDiskStore[] diskStoresFromOshi = OshiUtil.getHardware().getDiskStores();
//              {"PHYSICALDRIVE0":"BIWIN SSD (Standard disk drives)(1904051301056)"}
            diskStoresModel = Arrays.stream(diskStoresFromOshi)
                    .map(diskStoreFromOshi -> "\"" + diskStoreFromOshi.getName().replace("\\\\.\\", "") + "\":\"" +
                            StrUtil.removeSuffix(diskStoreFromOshi.getModel(), " (标准磁盘驱动器)") + "(" + diskStoreFromOshi.getSerial().trim() + ")\"")
                    .collect(Collectors.joining(",", "{", "}"));

        } catch (Exception e) {
            log.error("硬盘型号数据获取失败", e);
        }
        return diskStoresModel;
    }


    public static String diskTypeFromSmart(Map<String, String> diskInfoFromSmartMap, String diskModel) {
        String diskInfoFromSmart = diskInfoFromSmartMap.get(diskModel);
        String diskType = "/固态硬盘";
        if (null != diskInfoFromSmart) {
            if (diskInfoFromSmart.contains("机械硬盘")) {
                diskType = "/机械硬盘";
            } else if (diskInfoFromSmart.contains("固态硬盘")) {
                diskType = "/固态硬盘";
            }
        }

        return diskType;
    }

    public static void main(String[] args) throws SigarException {
//        System.out.println(Oshi4NoneSigarUtil.getDiskStoresModelFromOshi());

        /*Sigar sigar = new Sigar();
        FileSystem[] diskStores = sigar.getFileSystemList();
        for (FileSystem diskStore : diskStores) {
            System.out.println(diskStore.getSysTypeName());
        }*/

        System.out.println(getDiskStoresModelJsonFromOshi());
    }
}
