package com.priusis.utils;

import cn.hutool.system.oshi.OshiUtil;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import lombok.extern.slf4j.Slf4j;

/**
 * CreatProcess
 */
@Slf4j
public class ProcessExtensionsApqUtil {

//    static final String CP_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/apq_CreatProcess" + (OshiUtil.getOs().getBitness() == 64 ? "x64" : "") + ".dll", System.getProperty("user.dir") + "/apq-pc-common");
    static final String CP_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/apq_CreatProcess.dll", System.getProperty("user.dir") + "/apq-pc-common");
    static ProcessExtensionsApq CP_API_INSTANCE = Native.loadLibrary(CP_DLL_NAME, ProcessExtensionsApq.class);

    /**
     * 获取gpu温度
     *
     * @return
     */
    public static int apq_CreateProcessAsUser(String pNameStr) {
        int i = 0;
        try {
            log.info("=============================== s {}", pNameStr);
            Pointer pName = new Memory(pNameStr.length() + 1); // WARNING: assumes ascii-only string
            pName.setString(0, pNameStr);
            i = CP_API_INSTANCE.apq_CreateProcessAsUser(pName);
            log.info("=============================== e" + i);
        } catch (Exception e) {
            log.error("apq_CreateProcessAsUser error", e);
        }
        return i;
    }

    /**
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {
        String pNameStr = "C:\\windows\\notepad.exe D:\\info.log";
        ProcessExtensionsApqUtil.apq_CreateProcessAsUser(pNameStr);
    }

    private interface ProcessExtensionsApq extends Library {
        // 声明将要调用的DLL中的方法
        int apq_CreateProcessAsUser(Pointer pName);
    }

}
