package com.priusis.controller;


import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import com.priusis.lib.R;
import com.priusis.service.common.MacAddrService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * <p>
 * 设备表控制器
 * </p>
 */
@Slf4j
@RestController
@RequestMapping("/facility")
@Validated
public class FacilityController {

    @Value(value = "${apq.iot-gateway}")
    private String gateway;

    @Value(value = "${apq.url.voiceCall}")
    private String voiceCallUrl;

    @Value(value = "${apq.url.voiceCallPush}")
    private String voiceCallPushUrl;

    @Value(value = "${apq.url.device_info_g}")
    private String deviceInfoUrl;

    @Autowired
    private MacAddrService macAddrService;

    @PostMapping("voiceCallPush")
    public R voiceCallPush() {
        String reqUrl = gateway + voiceCallPushUrl;
        String mac = macAddrService.getMacAddr();

        JSONObject rsp = JSONUtil.parseObj(HttpUtil.post(reqUrl,
                JSONUtil.createObj().set("macAddress", mac).toString()));
        if (ObjectUtil.notEqual(rsp.getInt("code"), 0)) return R.error(rsp.getStr("msg"));

        return R.success();
    }

    @PostMapping("voiceCall")
    public R voiceCall() {
        String reqUrl = gateway + voiceCallUrl;
        String mac = macAddrService.getMacAddr();
//        String mac = "68:ED:A4:1D:E8:00";
        JSONObject rsp = JSONUtil.parseObj(HttpUtil.post(reqUrl,
                JSONUtil.createObj().set("macAddress", mac).toString()));
        if (ObjectUtil.notEqual(rsp.getInt("code"), 0)) return R.error(rsp.getStr("msg"));

        JSONObject rsp2 = JSONUtil.parseObj(HttpUtil.get(gateway + StrUtil.format(deviceInfoUrl, mac)));
        if (ObjectUtil.notEqual(rsp2.getInt("code"), 0)) {
            log.error("查询设备信息失败, msg: {}", rsp.getStr("msg"));
            return R.error("查询设备信息失败");
        }
        Long operationId = rsp2.getJSONObject("data").getLong("operationId");
        Long sysUserId = rsp2.getJSONObject("data").getLong("sysUserId");
        Long callUserId = operationId;
        if (null == callUserId) {
            callUserId = sysUserId;
        }
        if (null == callUserId) {
            return R.error("语音通话失败，目前接听用户不存在");
        }

        Map<String, Object> result = Maps.newHashMap();
        result.put("mac", mac);
        result.put("callUserId", callUserId);
        return R.success(result);
    }
}
