package com.priusis.dto;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author yanghan
 * @date 2022/1/12 10:48
 */
@Getter
@Setter
public class FacilityPropertyPCAddDto {
    /**
     * 资产编码
     */
    @Length(max = 64, message = "编码过长！")
    @NotNull(message = "编码不能为空！")
    private String propertyCode;
    /**
     * 使用人
     */
    @Length(max = 64, message = "使用人过长！")
    @NotNull(message = "使用人不能为空！")
    private String owner;
    /**
     * 地址
     */
    @Length(max = 255, message = "地址过长！")
    @NotNull(message = "地址不能为空！")
    private String address;
    /**
     * mac地址
     */
    private String macAddress;
    /**
     * 租户id
     */
    private Long tenantId;
}
