package com.priusis.client.service;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MqttRpcDataMessage implements Serializable {

    private static final long serialVersionUID = -3133461476074777891L;

    private int requestId;
    private String bizRequestId;
    private String method;
    private Long sendTime;
    private String params;

    @Override
    public String toString() {
        return "{requestId=" + requestId +
                ", sendTime=" + sendTime +
                ", method=" + method +
                ", params=" + params +
                '}';
    }
}
