package com.priusis.utils;

import cn.hutool.system.oshi.OshiUtil;
import lombok.extern.slf4j.Slf4j;
import oshi.software.os.OperatingSystem;

@Slf4j
public class Oshi4NoneSigarUtil {
    static String baseboard;
    static String diskStoresModel;
    static String os;

    public static String getBaseboardWithCache() {
        if (null == baseboard) {
            baseboard = OshiUtil.getSystem().getBaseboard().getManufacturer() + " " + OshiUtil.getSystem().getBaseboard().getVersion();
        }
        return baseboard;
    }

    public static String getOsWithCache() {
        if (null == os) {
            OperatingSystem ost = OshiUtil.getOs();
            os = ost.getManufacturer() + " " + ost.getFamily() + " " + ost.getVersionInfo().getVersion() + "(" + ost.getBitness() + ")";
        }
        return os;
    }

}
