package com.priusis.utils;

import com.sun.jna.Platform;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.UnsupportedEncodingException;

@Slf4j
public class ParseUrlUtil {
    /**
     * @param relatePath 相对路径 /qr/dat/
     * @return
     */
    public static String parseAbsolutePath(String relatePath, String defaultPath) {
        String path = defaultPath + relatePath;

        if (Platform.isWindows()) {
            try {
                path = ParseUrlUtil.class.getResource(relatePath).getPath();
                if (path.contains("BOOT-INF")) {
                    path = System.getProperty("user.dir") + File.separator + relatePath;
                }
            } catch (Exception e) {
                log.error("usr decode", e.getMessage());
                path = System.getProperty("user.dir") + File.separator + relatePath;
                if (!new File(path).exists()) {
                    path = defaultPath + relatePath;
                }
            }
//            path = path.replaceFirst("/", "");//排除中文空格
            path = path.replaceAll("%20", " ");//排除中文空格
            path = path.replaceAll("/", "\\\\");//排除中文空格
            try {
                path = java.net.URLDecoder.decode(path, "utf-8"); //解决路径包含中文的情况
            } catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncoding", e);
            }
            log.info("解析到PATH为:{}", path);
        }
        //if (Platform.isLinux()) {
        //    try {
        //        ApplicationHome h = new ApplicationHome(IHwPortController.class);
        //        File jarF = h.getSource();
        //        path = jarF.getParentFile().toString() + relatePath;
        //    } catch (Exception e) {
        //        path = "/app/smart-property/qr/dll";
        //    }
        //}

        return path;
    }

    /**
     * @param relatePath 相对路径 /qr/dat/
     * @return
     */
    public static String parseAbsolutePath(String target, String relatePath, String jarPath) {
        String path = "";

        if (Platform.isWindows()) {
            try {
                path = ParseUrlUtil.class.getResource("/").getPath();
                if (path.contains("BOOT-INF")) {
                    path = System.getProperty("user.dir") + File.separator + jarPath + File.separator + target;
                } else {
                    path = path + relatePath + File.separator + target;
                }
            } catch (Exception e) {
                log.error("usr decode", e.getMessage());
                return "";
            }
            path = path.replaceAll("%20", " ");//排除中文空格
            path = path.replaceAll("/", "\\\\");//排除中文空格
            try {
                path = java.net.URLDecoder.decode(path, "utf-8"); //解决路径包含中文的情况
            } catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncoding", e);
            }
            log.info("解析到PATH为:{}", path);
        }
        //if (Platform.isLinux()) {
        //    try {
        //        ApplicationHome h = new ApplicationHome(IHwPortController.class);
        //        File jarF = h.getSource();
        //        path = jarF.getParentFile().toString() + relatePath;
        //    } catch (Exception e) {
        //        path = "/app/smart-property/qr/dll";
        //    }
        //}

        return path;
    }

    public static void main(String[] args) {
        String path = ParseUrlUtil.parseAbsolutePath("apq.exe", "../../../tools/install-package/client/x64/client-soft", "../client-soft");
        System.out.println(path);
        if (!new File(path).exists()) {
            System.out.println("===============");
        }
    }

}
