package com.priusis.utils;

import cn.hutool.system.oshi.OshiUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;

import java.util.HashMap;
import java.util.Map;


/**
 * Java通过JNA调用WinRing0.dll实现模拟驱动级别按键
 */
public class WinRing0Util {
//    static final String WR0_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/WinRing0" + (OshiUtil.getOs().getBitness() == 64 ? "x64" : "") + ".dll",
//            System.getProperty("user.dir") + "/apq-pc-common");
    static final String WR0_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/WinRing0.dll",
            System.getProperty("user.dir") + "/apq-pc-common");

    static WR0 WR0_INSTANCE = Native.loadLibrary(WR0_DLL_NAME, WR0.class);

    /**
     * 获取dll的状态
     */
    public static int GetDllStatus() {
        return WR0_INSTANCE.GetDllStatus();
    }

    /**
     * 销毁
     */
    public static void DeinitializeOls() {
        WR0_INSTANCE.DeinitializeOls();
    }

    /**
     * 销毁
     */
    public static void doDeinitializeOls() {
        WinRing0Util.InitializeOls();
        WR0_INSTANCE.DeinitializeOls();
    }

    /**
     * 初始化
     */
    public static void InitializeOls() {
        WR0_INSTANCE.InitializeOls();
    }

    /**
     * 如果启动报错java.lang.UnsatisfiedLinkError: Unable to load library 'WinRing0x64':
     * 请将lib目录下的四个文件复制到jdk或jre的bin目录下
     *
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {

        WinRing0Util.doDeinitializeOls();
        /*//WinRing0初始化
        WinRing0Util.InitializeOls();
        //获取WinRing0的状态码
        WinRing0Util.GetDllStatus();
        int dllStatus = WinRing0Util.GetDllStatus();
        //销毁WinRing0
        WinRing0Util.DeinitializeOls();
        System.err.println("WinRing0 dllStatus:" + dllStatus);*/
    }

    private interface WR0 extends Library {
        // 声明将要调用的DLL中的方法
        int InitializeOls();

        int DeinitializeOls();

        int GetDllStatus();
    }

}
