package com.priusis.client.service;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.UUID;

@Data
@Builder
public class MqttPersistentMessage implements Serializable {

    private static final long serialVersionUID = -3133461476074777891L;

    private UUID id;
    private long timestamp;
    private int messageId;
    private String topic;
    private byte[] payload;

    @Override
    public String toString() {
        return "{payload=" + new String(payload) +
                ", timestamp=" + timestamp +
                ", topic='" + topic + '\'' +
                ", id=" + id +
                ", messageId=" + messageId +
                '}';
    }
}
