package com.priusis.config;

import com.priusis.lib.R;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

/**
 * @author yangli
 * @since 2021/09/09
 */
@Slf4j
@RestControllerAdvice
public class ExceptionHandlerAdvice {


    @ExceptionHandler(Exception.class)
    public R<Void> exception(Exception e, HttpServletRequest req) {
        log.error("uri: {}", req.getRequestURI(), e);
        return R.error();
    }
}
