package com.priusis.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.oshi.OshiUtil;
import oshi.hardware.NetworkIF;

/**
 * @author yangli
 * @since 2021/09/28
 */
public final class MacAddrUtil {
    public static String get() {
        for (NetworkIF networkIF : OshiUtil.getHardware().getNetworkIFs()) {
            if (ArrayUtil.isEmpty(networkIF.getIPv4addr())) continue;
            if (StrUtil.containsIgnoreCase(networkIF.getDisplayName(), "Virtual")) continue;
            return networkIF.getMacaddr();
        }
        return null;
    }
}
