package com.priusis.client.service;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;

public interface PersistentFileService {

    MqttDeliveryFuture persistMessage(String topic, int msgId, byte[] payload,
                                      Consumer<Void> onSuccess, Consumer<Throwable> onFailure) throws IOException;

    /**
     * Returns a list of the messages that are to be sent. If storage files exist, then the messages from oldest
     * storage file are returned and file is deleted. If no storage file exists, then returns the messages that are currently
     * in storage buffer and clears it
     *
     * @return {@see List} of {@see MqttPersistentMessage} to be sent
     * @throws IOException
     */
    List<MqttPersistentMessage> getPersistentMessages() throws IOException;

    /**
     * Returns a list of the messages that are to be re-sent
     *
     * @return {@see List} of {@see MqttPersistentMessage} to be re-sent
     * @throws IOException
     */
    List<MqttPersistentMessage> getResendMessages() throws IOException;

    void resolveFutureSuccess(UUID id);

    void resolveFutureFailed(UUID id, Throwable e);

    Optional<MqttDeliveryFuture> getMqttDeliveryFuture(UUID id);

    boolean deleteMqttDeliveryFuture(UUID id);

    Optional<Consumer<Void>> getSuccessCallback(UUID id);

    Optional<Consumer<Throwable>> getFailureCallback(UUID id);

    void saveForResend(MqttPersistentMessage message) throws IOException;

    void saveForResend(List<MqttPersistentMessage> messages) throws IOException;

    File flushRpcDataToFile(MqttRpcDataMessage mqttRpcDataMessage) throws IOException;

    MqttRpcDataMessage readFromFile(String method) throws IOException;
}
