﻿#pragma once

// 下列 ifdef 块是创建使从 DLL 导出更简单的
// 宏的标准方法。此 DLL 中的所有文件都是用命令行上定义的 HWPORTCONTROLLERDLL_EXPORTS
// 符号编译的。在使用此 DLL 的
// 任何项目上不应定义此符号。这样，源文件中包含此文件的任何其他项目都会将
// HWPORTCONTROLLERDLL_API 函数视为是从 DLL 导入的，而此 DLL 则将用此宏定义的
// 符号视为是被导出的。
#ifdef HWPORTCONTROLLERDLL_EXPORTS
#define HWPORTCONTROLLERDLL_API __declspec(dllexport)
#else
#define HWPORTCONTROLLERDLL_API __declspec(dllimport)
#endif


/*#ifdef __cplusplus
extern "C"
{
#endif*/

/* NOTE: 此库内所有函数必须使用管理员权限运行 */


/*------- Macro -------*/
#define MAX_RESTRICT_NET_BAND_SPEED 1000000000		// 1000 Mbps

/*------- Enum -------*/

/* 定义可配置权限的设备类型枚举类型 */
typedef enum
{
	APQ_HWPORT_DEVICE_TYPE_NORMAL = 0,				// 普通类设备
	APQ_HWPORT_DEVICE_TYPE_STORAGE = 1,				// 存储类设备
	APQ_HWPORT_DEVICE_TYPE_NET = 2,					// 网络类设备

	APQ_HWPORT_DEVICE_TYPE_MAX,	/* 不使用 */
} APQ_HWPORT_DEVICE_TYPE_E;

/* 定义普通类设备ID（如USB设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_NORMAL_DEVID_SERIAL = 0,				// 串口
	APQ_HWPORT_NORMAL_DEVID_GPIO = 1,				// GPIO
	APQ_HWPORT_NORMAL_DEVID_DONGLE = 2,				// 加密狗
	APQ_HWPORT_NORMAL_DEVID_MOUSE = 3,				// 鼠标
	APQ_HWPORT_NORMAL_DEVID_KEYBOARD = 4,			// 键盘
	APQ_HWPORT_NORMAL_DEVID_CAMERA = 5,				// 摄像头
	APQ_HWPORT_NORMAL_DEVID_USB_CONVERSION = 6,		// USB转换
	APQ_HWPORT_NORMAL_DEVID_BT = 7,					// 蓝牙
	//APQ_HWPORT_NORMAL_DEVID_OTHER = 8,				// 其他（此项不支持，必须指定要禁用类型）

	APQ_HWPORT_NORMAL_DEVID_MAX,	/* 不使用 */
} APQ_HWPORT_NORMAL_DEVID_E;

/* 定义普通类权限（如USB设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_NORMAL_PERM_UNKNOWN = 0,				// 未知权限，一般是未配置
	APQ_HWPORT_NORMAL_PERM_DENY = 1,				// 拒绝连接/使用此硬件接口
	APQ_HWPORT_NORMAL_PERM_ALLOW = 2,				// 允许连接/使用此硬件接口

	APQ_HWPORT_NORMAL_PERM_MAX,	/* 不使用 */
} APQ_HWPORT_NORMAL_PERM_E;


/* 定义存储类设备ID（存储设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_STORAGE_DEVID_CDROM = 0,				// 光驱
	APQ_HWPORT_STORAGE_DEVID_UDISK = 1,				// U盘, removable disk 
	//APQ_HWPORT_STORAGE_DEVID_HDD_DISK = 2,			// 移动硬盘, <==> APQ_HWPORT_STORAGE_DEVID_UDISK
	//APQ_HWPORT_STORAGE_DEVID_USB_TYPEC = 3,			// Type-C, <==> APQ_HWPORT_STORAGE_DEVID_UDISK

	APQ_HWPORT_STORAGE_DEVID_MAX,	/* 不使用 */
} APQ_HWPORT_STORAGE_DEVID_E;

/* 定义存储类权限（存储设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_STORAGE_PERM_UNKNOWN = 0,			// 未知权限，一般是未配置
	APQ_HWPORT_STORAGE_PERM_DENY = 1,				// 拒绝连接/使用此硬件接口
	APQ_HWPORT_STORAGE_PERM_ALLOW = 2,				// 允许连接/使用此硬件接口
	APQ_HWPORT_STORAGE_PERM_READ_WRITE = 3,			// 允许连接/使用此硬件接口，接口读写数据权限都有, <==> APQ_HWPORT_STORAGE_PERM_ALLOW
	APQ_HWPORT_STORAGE_PERM_READ_ONLY = 4,			// 允许连接/使用此硬件接口，接口只有读数据权限 r
	APQ_HWPORT_STORAGE_PERM_WRITE_IN_ONLY = 5,		// （等价于只读），允许连接/使用此硬件接口，接口只有拷入：支持读取数据以及向电脑拷入数据，不能从电脑拷出
	APQ_HWPORT_STORAGE_PERM_WRITE_OUT_ONLY = 6,		// （此项无效，无法禁止向电脑拷入，等价于拒绝），允许连接/使用此硬件接口，接口只有拷出：支持读取数据以及从电脑拷出数据，不能向电脑拷入

	APQ_HWPORT_STORAGE_PERM_MAX,	/* 不使用 */
} APQ_HWPORT_STORAGE_PERM_E;


/*定义网速类设备ID（网络设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_NET_DEVID_ETH_CARD = 0,				// 网口
	//APQ_HWPORT_NET_DEVID_WIFI = 1,					// WiFi <==> 网口
	//APQ_HWPORT_NET_DEVID_CELLULAR = 2,				// 4G + 5G <==> 网口

	APQ_HWPORT_NET_DEVID_MAX,	/* 不使用 */
} APQ_HWPORT_NET_DEVID_E;

/*定义网速类权限（网络设备）枚举类型 */
typedef enum
{
	APQ_HWPORT_NET_PERM_UNKNOWN = 0,				// 未知权限，一般是未配置
	APQ_HWPORT_NET_PERM_DENY = 1,					// 拒绝连接/使用此硬件接口
	APQ_HWPORT_NET_PERM_ALLOW = 2,					// 允许连接/使用此硬件接口
	APQ_HWPORT_NET_PERM_NO_LIMIT = 3,				// 不限制网络带宽, APQ_HWPORT_NET_PERM_ALLOW
	APQ_HWPORT_NET_PERM_LIMIT = 4,					// 限制网络带宽，速度值由参数speed指定

	APQ_HWPORT_NET_PERM_MAX,	/* 不使用 */
} APQ_HWPORT_NET_PERM_E;

/*定义返回结果枚举类型 */
typedef enum
{
	APQ_HWPORT_RESULT_OK = 0,						// 调用成功
	APQ_HWPORT_RESULT_ERROR_UNKNOWN = 1,			// 调用失败，未知原因
	APQ_HWPORT_RESULT_ERROR_INTERNAL = 2,			// 调用失败，内部错误
	APQ_HWPORT_RESULT_ERROR_PARAM = 3,				// 调用失败，参数错误
	APQ_HWPORT_RESULT_ERROR_RIGHTS = 4,				// 调用失败，需要管理员权限
	// ...
} APQ_HWPORT_RESULT_E;


/******************************************************************************************************************************
* 调用流程举例:
*		
*		// 定义回调函数
*		void device_change_cb_fn(int changeType, char *devInfoBuf)
*		{
*			printf("=== get cb type=%d, data=[%s]\r\n", changeType, devInfoBuf);
*		}
*
*
*		// --- 1. 初始化 ---
*		// 初始化接口
*		APQ_HWPORT_Initialize()
*
*		// 注册设备热插拔通知后，接收热插拔事件
*		APQ_HWPORT_Register_Device_Notification(device_change_cb_fn)
*
*		// --- 2. 权限操作 ---
*		// 可选：获取某个硬件接口权限
*		APQ_HWPORT_get_normal_device_permit()
*
*		// 设置某硬件接口权限
*		APQ_HWPORT_set_normal_device_permit()
*		APQ_HWPORT_set_storage_device_permit()
*		// 设置网络限速，将启动限速线程
*       APQ_HWPORT_set_net_device_permit(APQ_HWPORT_NET_DEVID_ETH_CARD, APQ_HWPORT_NET_PERM_LIMIT, 0, NULL);
*		// 应用配置
*		APQ_HWPORT_Apply()
*
*		// 解除网络限速，清理限速线程
* 		APQ_HWPORT_set_net_device_permit(APQ_HWPORT_NET_DEVID_ETH_CARD, APQ_HWPORT_NET_PERM_NO_LIMIT, 0, NULL);
*		// 应用配置
*		APQ_HWPORT_Apply()
*
*		// --- 3. 清理资源 ---
*		// 停止监听并释放资源
*		APQ_HWPORT_Unregister_Device_Notification()
*
*		// 清理资源
*		APQ_HWPORT_Uninitialize()
* 
******************************************************************************************************************************/

/*------- Function -------*/

/******************************************************************************************************************************
*函数名：APQ_HWPORT_Initialize
*功  能：初始化硬件接口管理模块
*参  数：
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：调用其他接口前必须调用一次此接口初始化资源
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_Initialize();   1

/******************************************************************************************************************************
*函数名：APQ_HWPORT_Apply
*功  能：应用硬件接口管理模块的配置内容
*参  数：
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：调用完成此接口后，设置才会生效
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_Apply();    1

/******************************************************************************************************************************
*函数名：APQ_HWPORT_Uninitialize
*功  能：清理硬件接口管理模块
*参  数：
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：最后必须调用此函数清理资源
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_Uninitialize();   1


/******************************************************************************************************************************
*函数名：APQ_HWPORT_set_normal_device_permit
*功  能：设置普通设备权限
*参  数：
	IN APQ_HWPORT_NORMAL_DEVID_E device_id: 	枚举类型设备ID号
	IN APQ_HWPORT_NORMAL_PERM_E perm: 			普通类权限
	IN char *data: 							预留参数字串，未明确的传NULL
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_set_normal_device_permit(IN APQ_HWPORT_NORMAL_DEVID_E device_id, IN APQ_HWPORT_NORMAL_PERM_E perm, IN char *data);
1
/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_normal_device_permit
*功  能：获取普通设备权限
*参  数：
	IN APQ_HWPORT_NORMAL_DEVID_E device_id: 		指定普通设备硬件接口类型
*返回值：返回 APQ_HWPORT_NORMAL_PERM_E 权限类型
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_NORMAL_PERM_E APQ_HWPORT_get_normal_device_permit(IN APQ_HWPORT_NORMAL_DEVID_E device_id);
1

/******************************************************************************************************************************
*函数名：APQ_HWPORT_set_storage_device_permit
*功  能：设置可移动存储设备权限
*参  数：
	IN APQ_HWPORT_STORAGE_DEVID_E device_id: 	枚举类型设备ID号
	IN APQ_HWPORT_STORAGE_PERM_E perm: 			存储类权限
	IN char *data: 							预留参数字串，未明确的传NULL
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_set_storage_device_permit(IN APQ_HWPORT_STORAGE_DEVID_E device_id, IN APQ_HWPORT_STORAGE_PERM_E perm, IN char *data);
1
/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_storage_device_permit
*功  能：获取可移动存储设备权限
*参  数：
	IN APQ_HWPORT_NORMAL_DEVID_E device_id: 		指定可移动存储设备硬件接口类型
*返回值：返回 APQ_HWPORT_NORMAL_PERM_E 权限类型
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_STORAGE_PERM_E APQ_HWPORT_get_storage_device_permit(IN APQ_HWPORT_STORAGE_DEVID_E device_id);

1
/******************************************************************************************************************************
*函数名：APQ_HWPORT_set_net_device_permit
*功  能：设置网络设备权限
*参  数：
	IN APQ_HWPORT_NET_DEVID_E device_id: 	枚举类型设备ID号
	IN APQ_HWPORT_NET_PERM_E perm: 			网络类权限
	IN int speed: 						带宽限制值，单位KB/s
	IN char *data: 						预留参数字串，未明确的传NULL
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注： 设置限速选项会启动限速线程，退出程序时需要调用APQ_HWPORT_NET_PERM_NO_LIMIT或者其他不限速的权限清理限速线程
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_set_net_device_permit(IN APQ_HWPORT_NET_DEVID_E device_id, IN APQ_HWPORT_NET_PERM_E perm, IN int speed, IN char *data);
1
/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_net_device_permit
*功  能：获取网络设备权限
*参  数：
	IN APQ_HWPORT_NORMAL_DEVID_E device_id: 		指定网络设备硬件接口类型
	OUT int *pSpeed:								返回存放配置内的带宽限速值，单位KB/s
*返回值：返回 APQ_HWPORT_NORMAL_PERM_E 权限类型
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_NET_PERM_E APQ_HWPORT_get_net_device_permit(IN APQ_HWPORT_NET_DEVID_E device_id, OUT int *pSpeed);
1


/******************************************************************************************************************************
*功  能：注册设备热插拔通知后，接收热插拔事件
*参  数：
	int changeType: 						代表该设备状态，1代表插入，2代表拔出
	char *devInfoBuf:						存放识别到的设备信息（易读信息文本，用逗号区分："设备描述","友好名称","总线已报告设备描述","提供商"）
******************************************************************************************************************************/
typedef void(*P_DEVICE_CHANGE_CB)(int changeType, char *devInfoBuf);

/******************************************************************************************************************************
*函数名：APQ_HWPORT_Register_Device_Notification
*功  能：注册设备热插拔通知（如USB设备）
*参  数：
	IN P_DEVICE_CHANGE_CB callback_fn: 		指定事件发生时的回调函数
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：不使用时，需要调用 APQ_HWPORT_Unregister_Device_Notification 停止监听并释放资源
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_Register_Device_Notification(IN P_DEVICE_CHANGE_CB callback_fn);   0

/******************************************************************************************************************************
*函数名：APQ_HWPORT_Register_Device_Notification
*功  能：停止监听并释放设备热插拔通知相关资源
*参  数：
*返回值：成功返回 APQ_HWPORT_RESULT_OK，失败返回 APQ_HWPORT_RESULT_ERROR_开头的值
*备  注：
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API APQ_HWPORT_RESULT_E APQ_HWPORT_Unregister_Device_Notification(void); 1



/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_dev_str_by_id
*功  能：根据设备类型和所属设备的权限类型获取权限字符名，用于打印结果
*参  数：
	IN APQ_HWPORT_DEVICE_TYPE_E device_type: 		指定设备类型
	IN int perm_type: 							指定所属设备的设备ID类型，强制转成int，如(int)APQ_HWPORT_STORAGE_DEVID_UDISK
*返回值：0成功，-1失败
*备  注：用于打印结果，非必要不使用
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API const char * APQ_HWPORT_get_dev_str_by_id(IN APQ_HWPORT_DEVICE_TYPE_E device_type, IN int devid_type);

/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_perm_str_by_id
*功  能：根据设备类型和所属设备的权限类型获取权限字符名，用于打印结果
*参  数：
	IN APQ_HWPORT_DEVICE_TYPE_E device_type: 		指定设备类型
	IN int perm_type: 							指定所属设备的权限类型，强制转成int，如(int)APQ_HWPORT_STORAGE_PERM_DENY
*返回值：权限字符名
*备  注：用于打印结果，非必要不使用
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API const char *APQ_HWPORT_get_perm_str_by_id(IN APQ_HWPORT_DEVICE_TYPE_E device_type, IN int perm_type);

/******************************************************************************************************************************
*函数名：APQ_HWPORT_get_perm_id_by_str
*功  能：根据设备类型和所属设备的权限字符名获取权限类型，用于打印结果
*参  数：
	IN APQ_HWPORT_DEVICE_TYPE_E device_type: 		指定设备类型
	IN const char* perm_str: 					指定所属设备的权限字符名
*返回值：权限类型，需强制转换成对应enum类型
*备  注：用于打印结果，非必要不使用
******************************************************************************************************************************/
HWPORTCONTROLLERDLL_API const int APQ_HWPORT_get_perm_id_by_str(IN APQ_HWPORT_DEVICE_TYPE_E device_type, IN const char* perm_str);

/*#ifdef __cplusplus
}
#endif*/
