package com.priusis.client.extensions.http.conf.mapping;

import com.priusis.client.service.data.DeviceData;
import com.priusis.client.util.converter.BasicJsonConverter;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

import java.util.regex.Pattern;

import static com.priusis.client.util.JsonTools.fromString;

@Data
@EqualsAndHashCode(callSuper = true)
@Slf4j
public class HttpDeviceDataConverter extends BasicJsonConverter {

    public static final Pattern TAG_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public DeviceData parseBody(String body) {
        try {
            return parseDeviceData(fromString(body));
        } catch (Exception e) {
            log.error("Exception occurred while parsing json request body [{}]", body, e);
            throw new RuntimeException("Exception occurred while parsing json request body [" + body + "]", e);
        }
    }
}
