package com.priusis.client.service.core;

import com.priusis.client.data.kv.KvEntry;
import com.priusis.client.service.MqttDeliveryFuture;
import com.priusis.client.service.MqttRpcDataMessage;
import com.priusis.client.service.conf.PcExtensionConfiguration;
import com.priusis.client.service.data.AttributeRequest;
import com.priusis.client.service.data.AttributeResponse;
import com.priusis.client.service.data.AttributesUpdateSubscription;
import com.priusis.client.service.data.RpcCommandResponse;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;

/**
 * Created by priusis on 16.01.17.
 */
public interface MqttService {

    void init() throws Exception;

    void destroy() throws Exception;

    String getTenantLabel();

    /**
     * Report device attributes change to Priusisiot
     *
     * @param attributes - the attribute values list
     */
    MqttDeliveryFuture onDeviceAttributesUpdate(List<KvEntry> attributes);

    /**
     * Report device event change to Priusisiot
     *
     * @param attributes - the attribute values list
     */
    MqttDeliveryFuture onDeviceEventUpdate(List<KvEntry> attributes);

    /**
     * Report attributes request to Priusisiot
     *
     * @param attributeRequest - attributes request
     * @param listener         - attributes response
     */
    void onDeviceAttributeRequest(AttributeRequest attributeRequest, Consumer<AttributeResponse> listener);

    /**
     * Report response from device to the server-side RPC call from Priusisiot
     *
     * @param response - the device response to RPC call
     */
    void onDeviceRpcResponse(RpcCommandResponse response);

    /**
     * Subscribe to attribute updates from Priusisiot
     *
     * @param subscription - the subscription
     * @return true if successful, false if already subscribed
     */
    boolean subscribe(AttributesUpdateSubscription subscription);

    /**
     * Unsubscribe to attribute updates from Priusisiot
     *
     * @param subscription - the subscription
     * @return true if successful, false if already unsubscribed
     */
    boolean unsubscribe(AttributesUpdateSubscription subscription);

    /**
     * Report generic error from one of gateway components
     *
     * @param e - the error
     */
    void onError(Exception e);

    /**
     * Report error related to device
     *
     * @param deviceName - the device name
     * @param e          - the error
     */
    void onError(String deviceName, Exception e);

    /**
     * Report applied configuration
     *
     * @param configuration - extension configuration
     */
    void onAppliedConfiguration(String configuration);

    /**
     * Report extension configuration error
     *
     * @param e             - the error
     * @param configuration - extension configuration
     */
    void onConfigurationError(Exception e, PcExtensionConfiguration configuration);

    /**
     * Report extension configuration status
     *
     * @param id     - extension id
     * @param status - extension status
     */
    void onConfigurationStatus(String id, String status);

    /**
     * rpc请求落文件
     *
     * @param mqttRpcDataMessage
     * @return
     * @throws IOException
     */
    File flushRpcDataToFile(MqttRpcDataMessage mqttRpcDataMessage) throws IOException;

    /**
     * 读取
     *
     * @param method
     * @return
     * @throws IOException
     */
    MqttRpcDataMessage readFromFile(String method) throws IOException;
}
