package com.priusis.lib;

import lombok.Getter;

@Getter
public class R<T> {
    private final int code;
    private final String msg;
    private final T data;

    private R(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> R<T> success(T data) {
        return new R<>(0, "SUCCESS", data);
    }

    public static <T> R<T> success() {
        return success(null);
    }

    public static <T> R<T> error(int code, String msg, T data) {
        return new R<>(code, msg, data);
    }

    public static <T> R<T> error(int code, String msg) {
        return error(code, msg, null);
    }

    public static <T> R<T> error(String msg) {
        return error(500, msg);
    }

    public static <T> R<T> error() {
        return error("系统异常");
    }
}
