package com.priusis.dto;

import lombok.Data;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Data
public class HwPortControllerDto {

    // doType： 1允许 2禁止
    // limitType：1读写 2只读 3拷入 4拷出 5不限速 6限速
    // [
    // {"key":"USB_DRIVE","doType":1,"limitType":1},
    // {"key":"NETWORK_PORT","doType":1,"limitType":1,"value":10},
    // {"key":"SERIAL_PORT","doType":1}
    // ]

    /**
     * 设备硬件类型
     * <p>
     * U盘-USB_DRIVE              Storage   0     1F/2T/3T-ALL/4T-R/5T-CI/6T-CO   拷出目前无用！！
     * 移动硬盘-MOBILE_DRIVE       Storage   0     1F/2T/3T-ALL/4T-R/5T-CI/6T-CO   拷出目前无用！！
     * 驱动-CD_DRIVE              Storage   0     1F/2T/3T-ALL/4T-R/5T-CI/6T-CO   拷出目前无用！！
     * TYPE-C-TYPE-C             Storage   Storage移动硬盘，TYPEC  无效  ！！
     * <p>
     * 鼠标键盘-MOUSE_KEYBOARD     Normal    3+4   1F/2T
     * 加密狗-DONGLE              Normal    2     1F/2T
     * USB转换-USB_TRANSFORM      Normal    6     1F/2T
     * 摄像头-CAMERA              Normal    5     1F/2T
     * 串口-SERIAL_PORT           Normal    0     1F/2T
     * GPIO-GPIO                 Normal    1     1F/2T
     * 无线蓝牙-BLUETOOTH         Normal    7     1F/2T
     * <p>
     * 网口，4G/5G模块，无线WIFI区分不了 ！！
     * 网口-NETWORK_PORT          NET      0     1F/2T/3T-NS/4T-S-200
     * 4G/5G模块-MODULE_45G
     * 无线WIFI-WIFI
     */
    private DeviceHardwareEnum key;

    /**
     * 1允许 2禁止
     */
    private int doType;

    /**
     * 1读写 2只读 3拷入 4拷出 5不限速 6限速
     */
    private int limitType;

    /**
     * 限速值
     */
    private int value;

    /**
     * 定义普通类设备ID（如USB设备）枚举类型
     */
    @Getter
    public enum DeviceHardwareEnum {
        // Storage  1F/2T/3T-ALL/4T-R/5T-CI/6T-CO   拷出目前无用！！ Storage移动硬盘，TYPEC  无效  ！！
        USB_DRIVE(1, "Storage", "U盘"),
        MOBILE_DRIVE(1, "Storage", "移动硬盘"),
        CD_DRIVE(0, "Storage", "驱动"),
        TYPE_C(1, "Storage", "TYPE_C"),

        // Normal  1F/2T
        MOUSE_KEYBOARD(Arrays.asList(3, 4), "Normal", "鼠标键盘"),
        DONGLE(2, "Normal", "加密狗"),
        USB_TRANSFORM(6, "Normal", "USB转换"),
        CAMERA(5, "Normal", "摄像头"),
        SERIAL_PORT(0, "Normal", "串口"),
        GPIO(1, "Normal", "GPIO"),
        BLUETOOTH(7, "Normal", "无线蓝牙"),

        // NET  1F/2T/3T-NS/4T-S-200   网口，4G/5G模块，无线WIFI区分不了 ！！
        NETWORK_PORT(0, "NET", "网口"),
        MODULE_45G(0, "NET", "4G/5G模块"),
        WIFI(0, "NET", "无线WIFI"),

        ;
        private List<Integer> hwDeviceIds;

        private String hwGroup;

        private String name;

        DeviceHardwareEnum(List<Integer> hwDeviceIds, String hwGroup, String name) {
            this.hwDeviceIds = hwDeviceIds;
            this.hwGroup = hwGroup;
            this.name = name;
        }

        DeviceHardwareEnum(Integer hwDeviceId, String hwGroup, String name) {
            this.hwDeviceIds = new ArrayList<>();
            this.hwDeviceIds.add(hwDeviceId);
            this.hwGroup = hwGroup;
            this.name = name;
        }
    }
}
