package com.priusis;

import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.system.oshi.OshiUtil;
import com.priusis.vo.MqttRpcDataMessage;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.client.RestTemplate;
import oshi.hardware.NetworkIF;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest
public class RestTest {

    @Autowired
    private RestTemplate restTemplate;

    @Test
    public void test1() throws Exception {
        // 获取采集配置，数据上报频率 params == data
        ResponseEntity<MqttRpcDataMessage> forEntity = restTemplate.getForEntity("http://localhost:8765/rpc_cmd/info", MqttRpcDataMessage.class);
        System.out.println(forEntity.getBody().getMethod());
        System.out.println(forEntity.getBody().getParams());

        // 上报PC实时信息
        InetAddress inetAddress = InetAddress.getLocalHost();
        NetworkIF networkIF = new NetworkIF();
        networkIF.setNetworkInterface(NetworkInterface.getByInetAddress(inetAddress));
        Map<String, Object> data = MapUtil.<String, Object>builder()
                .put("operatingSystem", OshiUtil.getOs().toString())
                .put("mac", networkIF.getMacaddr())
                .put("baseboard", OshiUtil.getSystem().getBaseboard().getManufacturer() + " " + OshiUtil.getSystem().getBaseboard().getVersion())
                .put("ip", inetAddress.getHostAddress())
                .put("cpuModel", OshiUtil.getCpuInfo(0).getCpuModel())
                .put("cpuTemp", OshiUtil.getSensors().getCpuTemperature())
                .put("memoryCap", DataSizeUtil.format(OshiUtil.getMemory().getTotal()))
                .put("diskModel", OshiUtil.getHardware().getDiskStores()[0].getModel())
                .put("diskCap", DataSizeUtil.format(OshiUtil.getHardware().getDiskStores()[0].getSize()))
                .build();
        Map map = restTemplate.postForObject("http://localhost:8765/uplink/oc-client", data, Map.class);
        System.out.println(map);
    }
}
