package com.priusis.cache;

import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author yangli
 * @since 2021/09/22
 */
@Component
@Slf4j
public class InstalledProgramCache {

    private static List<Map<String, String>> programList;

    private static final Map<String, String> programInfoKey4NameCache = new HashMap<>();

    public List<Map<String, String>> getPrograms() throws IOException {
//        if (programList == null) loadProgramListJob();
        return programList;
    }


//    @Scheduled(fixedDelay = 240000)
    public void loadProgramListJob() {
        log.info("load安装程序开始");
        programInfoKey4NameCache.clear();
        List<Map<String, String>> programs = new ArrayList<>();
        String[] regPaths = {
                "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\",
                "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"
        };
        try {
            for (String regPath : regPaths) {
                Process process = Runtime.getRuntime().exec("cmd /c reg query " + regPath);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"))) {
                    String key;
                    while ((key = reader.readLine()) != null) {
                        if (StrUtil.isBlank(key)) {
                            continue;
                        }
                        Map<String, String> info = queryProgramInfo(key);
                        if (null != info) programs.add(info);
                    }
                    process.destroy();
                }
            }
        } catch (IOException e) {
            log.error("load安装程序异常", e);
        }
        programList = programs;
        log.info("load安装程序结束，programs：{}", programs);
    }

    private static Map<String, Map<String, String>> programInfoCache = new ConcurrentHashMap<>();

    private Map<String, String> queryProgramInfo(String key) throws IOException {
        if (programInfoCache.containsKey(key)) {
            Map<String, String> infoCache = programInfoCache.get(key);
            if (infoCache.containsKey("name") && !programInfoKey4NameCache.containsKey(infoCache.get("name"))) {
                return infoCache;
            }
            return null;
        }
        Map<String, String> info = new HashMap<>();
        Process process = Runtime.getRuntime().exec("cmd /c reg query " + key);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"))) {
            reader.readLine();
            reader.readLine();
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if (line.startsWith("DisplayName")) {
                    info.put("name", line.replace("DisplayName", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("DisplayVersion")) {
                    info.put("version", line.replace("DisplayVersion", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("InstallLocation")) {
                    info.put("path", line.replace("InstallLocation", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("DisplayIcon")) {
                    info.put("startPath", line.replace("DisplayIcon", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("UninstallString")) {
                    info.put("uninstallPath", line.replace("UninstallString", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("Publisher")) {
                    info.put("publisher", line.replace("Publisher", "").replace("REG_SZ", "").trim());
                } else if (line.startsWith("SystemComponent")) {
                    info.put("systemComponent", line.replace("SystemComponent", "").replace("REG_DWORD", "").trim());
                }
            }
            process.destroy();
        }

        programInfoCache.put(key, info);

        if (info.containsKey("name")/* && !programInfoKey4NameCache.containsKey(info.get("name"))*/) {
            programInfoKey4NameCache.put(info.get("name"), key);
            return info;
        }

        return null;
    }

    public void updateProgramInfoCacheByName(String name) throws Exception {
        if (programInfoKey4NameCache.containsKey(name)) {
            String nameForKey = programInfoKey4NameCache.get(name);
            programInfoCache.remove(nameForKey);
            Map<String, String> queryProgramInfoMap = queryProgramInfo(nameForKey);
            if (null != queryProgramInfoMap) {
                Integer removeIndex = null;
                for (int i = 0; i < programList.size(); i++) {
                    Map<String, String> programListOneMap = programList.get(i);
                    if (StrUtil.equals(programListOneMap.get("name"), name)) {
                        removeIndex = i;
                        break;
                    }
                }
                if (null != removeIndex) {
                    programList.remove(removeIndex);
                }
                programList.add(queryProgramInfoMap);
            } else {
                clearProgramInfoCache();
                loadProgramListJob();
            }
        }
    }

    public void updateProgramInfoCacheByNameAndVersion(String name, String version) throws Exception {
        if (programInfoKey4NameCache.containsKey(name)) {
            String nameForKey = programInfoKey4NameCache.get(name);
            programInfoCache.remove(nameForKey);
            Map<String, String> queryProgramInfoMap = new HashMap<>();
            Integer removeIndex = null;
            for (int i = 0; i < programList.size(); i++) {
                Map<String, String> programListOneMap = programList.get(i);
                if (StrUtil.equals(programListOneMap.get("name"), name)) {
                    removeIndex = i;
                    break;
                }
            }
            if (null != removeIndex) {
                programList.remove(removeIndex);
            }
            queryProgramInfoMap.put("name", name);
            queryProgramInfoMap.put("version", version);
            programList.add(queryProgramInfoMap);
        }
    }

    public void clearProgramInfoCacheByName(String name) throws Exception {
        if (programInfoKey4NameCache.containsKey(name)) {
            String nameForKey = programInfoKey4NameCache.get(name);
            programInfoCache.remove(nameForKey);
            Integer removeIndex = null;
            for (int i = 0; i < programList.size(); i++) {
                Map<String, String> programListOneMap = programList.get(i);
                if (StrUtil.equals(programListOneMap.get("name"), name)) {
                    removeIndex = i;
                    break;
                }
            }
            if (null != removeIndex) {
                programList.remove(removeIndex);
            }
        }
    }

    // 30分钟清除一次缓存
//    @Scheduled(fixedDelay = 1800000)
    public void clearProgramInfoCache() {
        programInfoCache.clear();
    }
}
