package com.priusis.utils.sigar;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import org.apache.commons.io.IOUtils;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 获取系统磁盘信息
 */
public class SigarGetDisk {

    public static void main2(String[] args) throws InterruptedException, SigarException {
        Sigar sigar = new Sigar();
        FileSystemUsage sfileSystemUsage = null;
        FileSystemUsage efileSystemUsage = null;

        List<FileSystem> list = Arrays.asList(sigar.getFileSystemList());
        String diskName = "";
        double total = 0;
        double usePercent = 0;

        double startreads = 0;
        double startwrites = 0;

        double endreads = 0;
        double endwrites = 0;

        double reads = 0;
        double writes = 0;

        long start = System.currentTimeMillis();
        for (int i = 0; i < list.size(); i++) {
            diskName += list.get(i);
            try {
                sfileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
            } catch (SigarException e) {// 当fileSystem.getType()为5时会出现该异常——此时文件系统类型为光驱
                continue;
            }
            total += sfileSystemUsage.getTotal();
            usePercent += sfileSystemUsage.getUsePercent();

            startreads += sfileSystemUsage.getDiskReads();
            startwrites += sfileSystemUsage.getDiskWrites();
        }

        Thread.sleep(1000);
        long end = System.currentTimeMillis();
        for (int i = 0; i < list.size(); i++) {
            try {
                efileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
            } catch (SigarException e) {// 当fileSystem.getType()为5时会出现该异常——此时文件系统类型为光驱
                continue;
            }

            endreads += efileSystemUsage.getDiskReads();
            endwrites += efileSystemUsage.getDiskWrites();
        }

        reads = ((endreads - startreads) * 8 / (end - start) * 1000);
        writes = ((endwrites - startwrites) * 8 / (end - start) * 1000);

        // 读
        String readss = String.format("%.1f", reads) + " KB/s";
        // 写
        String writess = String.format("%.1f", writes) + " KB/s";
        // 磁盘容量
        String totals = "";

        if (total / 1024 / 1024 / 1024 > 1) {

            totals = String.format("%.1f", total / 1024 / 1024 / 1024) + " TB";
        } else if (total / 1024 / 1024 > 1) {

            totals = String.format("%.1f", total / 1024 / 1024) + " GB";
        } else if (total / 1024 > 1) {
            totals = String.format("%.1f", total / 1024) + " MB";
        } else if (total <= 1) {
            totals = String.format("%.1f", total) + " KB";
        }

        // 磁盘使用率
        String usePercents = String.format("%.2f", usePercent / list.size() * 100) + " %";

        System.out.println("磁盘名=======" + diskName);
        System.out.println("总容量=======" + totals);
        System.out.println("磁盘使用率=======" + usePercents);
        System.out.println("读取速度=======" + readss);
        System.out.println("写入速度=======" + writess);

        // 关闭sigar
        sigar.close();

    }


    /**
     * 通过命令获取json格式硬盘Smart信息   包括温度  smartmontools https://www.smartmontools.org/
     * <p>
     * smart检测参数详解
     * https://www.cnblogs.com/york-hust/p/3380928.html
     * <p>
     * NVMe:
     * "nvme_smart_health_information_log": {
     * "critical_warning": 0,
     * "temperature": 41,
     * "available_spare": 100,
     * "available_spare_threshold": 10,
     * "percentage_used": 15,
     * "data_units_read": 16025772,
     * "data_units_written": 25319962,
     * "host_reads": 570186191,
     * "host_writes": 267947457,
     * "controller_busy_time": 6581,
     * "power_cycles": 2230,
     * "power_on_hours": 1069,
     * "unsafe_shutdowns": 181,
     * "media_errors": 0,
     * "num_err_log_entries": 1450,
     * "warning_temp_time": 0,
     * "critical_comp_time": 0,
     * "temperature_sensors": [
     * 41
     * ]
     * }
     * <p>
     * ATA:
     * ID# ATTRIBUTE_NAME          FLAG     VALUE WORST THRESH TYPE      UPDATED  WHEN_FAILED RAW_VALUE
     * 1 Raw_Read_Error_Rate     0x000f   082   064   ---    Pre-fail  Always       -       142381110
     * 3 Spin_Up_Time            0x0003   100   100   ---    Pre-fail  Always       -       0
     * 4 Start_Stop_Count        0x0032   068   068   ---    Old_age   Always       -       33205
     * 5 Reallocated_Sector_Ct   0x0033   100   100   ---    Pre-fail  Always       -       0
     * 7 Seek_Error_Rate         0x000f   083   060   ---    Pre-fail  Always       -       193110192
     * 9 Power_On_Hours          0x0032   091   091   ---    Old_age   Always       -       8010 (100 123 0)
     * 10 Spin_Retry_Count        0x0013   100   100   ---    Pre-fail  Always       -       0
     * 12 Power_Cycle_Count       0x0032   098   098   ---    Old_age   Always       -       2229
     * 184 End-to-End_Error        0x0032   100   100   ---    Old_age   Always       -       0
     * 187 Reported_Uncorrect      0x0032   100   100   ---    Old_age   Always       -       0
     * 188 Command_Timeout         0x0032   100   100   ---    Old_age   Always       -       0
     * 189 High_Fly_Writes         0x003a   100   100   ---    Old_age   Always       -       0
     * 190 Airflow_Temperature_Cel 0x0022   064   050   ---    Old_age   Always       -       36 (Min/Max 22/42)
     * 191 G-Sense_Error_Rate      0x0032   100   100   ---    Old_age   Always       -       27
     * 192 Power-Off_Retract_Count 0x0032   088   088   ---    Old_age   Always       -       25169
     * 193 Load_Cycle_Count        0x0032   023   023   ---    Old_age   Always       -       154769
     * 194 Temperature_Celsius     0x0022   036   050   ---    Old_age   Always       -       36 (0 8 0 0 0)
     * 196 Reallocated_Event_Count 0x0032   100   100   ---    Old_age   Always       -       0
     * 197 Current_Pending_Sector  0x0012   100   100   ---    Old_age   Always       -       0
     * 198 Offline_Uncorrectable   0x0010   100   100   ---    Old_age   Offline      -       0
     * 199 UDMA_CRC_Error_Count    0x003e   200   200   ---    Old_age   Always       -       0
     * 240 Head_Flying_Hours       0x000f   093   093   ---    Pre-fail  Always       -       6490 (120 14 0)
     * 254 Free_Fall_Sensor        0x0032   100   100   ---    Old_age   Always       -       0
     *
     * @return json字符串
     * @throws IOException 获取Smart信息错误
     */
    public static String getDiskTempFromSmart() throws IOException {
        Process process;
        String smartScan = "";
        List<String> smartScanList = new ArrayList<>();
        String result = "";
        process = Runtime.getRuntime().exec("D:\\Program Files\\smartmontools\\bin\\smartctl --scan -j");  // AHCI ATA NVMe   https://blog.csdn.net/u012459957/article/details/51226658
        try (InputStream inputStream = process.getInputStream()) {
            smartScan = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
        }

        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int index = 0;
        try {
            JSONArray devices = JSONUtil.parseObj(smartScan).getJSONArray("devices");
            List<String> deviceDataEList = new ArrayList<>();
            for (int i = 0; i < devices.size(); i++) {
                String name = devices.getJSONObject(i).getStr("name");
                process = Runtime.getRuntime().exec("D:\\Program Files\\smartmontools\\bin\\smartctl -A -i " + name + " -j");
                String smartctlAinfo = "";
                try (InputStream inputStream = process.getInputStream()) {
                    smartctlAinfo = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
                }
//            String protocol = devices.getJSONObject(1).getStr("protocol");
                //        if (Objects.equals(protocol, "NVMe")) {
                //
                //        } else if (Objects.equals(protocol, "ATA")) {
                //
                //        }
                JSONObject smartctlInfoJsonObject = JSONUtil.parseObj(smartctlAinfo);
                Integer diskTemp = smartctlInfoJsonObject.getJSONObject("temperature").getInt("current");
                String serialNumber = smartctlInfoJsonObject.getStr("serial_number");
                String modelName = smartctlInfoJsonObject.getStr("model_name");

                if (!deviceDataEList.contains(modelName)) {
                    if (index != 0) {
                        sb.append(",");
                    }
                    sb.append("{");
                    sb.append("\"diskTemp\":\"").append(diskTemp).append("\",");
                    sb.append("\"modelName\":\"").append(modelName).append("\",");
                    sb.append("\"serialNumber\":\"").append(serialNumber).append("\"");
                    sb.append("}");
                    deviceDataEList.add(modelName);
                    index++;
                }
            }

        } catch (Exception e) {
        }
        sb.append("]");
        result = sb.toString();

        if (process.isAlive()) {
            process.destroy();
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(getDiskTempFromSmart());
    }
}
