package com.priusis.utils.sigar;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.system.oshi.OshiUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.hyperic.sigar.*;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.*;

@Slf4j
public class SigarUtil {

    public static final Sigar sigar;

    static {
        sigar = new Sigar();
    }

    public static void main(String[] args) {
        try {
            while (true) {
//                // System信息，从jvm获取
//                property();
//                System.out.println("----------------------------------");
//                // cpu信息
//                cpu();
//                System.out.println("----------------------------------");
//                // 内存信息
//                memory();
//                System.out.println("----------------------------------");
//                // 操作系统信息
//                os();
//                System.out.println("----------------------------------");
//                // 用户信息
//                who();
//                System.out.println("----------------------------------");
//                // 文件系统信息
//                file();
//                System.out.println("----------------------------------");
//                disk(sigar);
//                // 网络信息
//                net();
//                System.out.println("----------------------------------");
//                // 以太网信息
                System.out.println(ethernetSimple(sigar));
                System.out.println("----------------------------------");
                Thread.sleep(15000);
            }

        } catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void writeSigar(PrintWriter writer, int mode) {
        if (mode == 1) {
            String cpu = "0";
            long memory = 0;
            long jvm = 0;
            long disk = 0;
            try {
                Swap swap = sigar.getSwap();
                cpu = SigarUtil.cpu(sigar);
                memory = SigarUtil.memory(sigar);
                jvm = SigarUtil.jvm(sigar);
                disk = SigarUtil.disk(sigar);
            } catch (Exception e) {
                //e.printStackTrace();
            }
            writer.write("<sigar ");
            writer.write(" cpu=\"" + cpu + "\"");
            writer.write(" memory=\"" + memory + "\"");
            writer.write(" jvm=\"" + jvm + "\"");
            writer.write(" disk=\"" + disk + "\"");
            writer.write(" />");
        }
    }

    public static void property() throws UnknownHostException {
        Runtime r = Runtime.getRuntime();
        Properties props = System.getProperties();
        InetAddress addr;
        addr = InetAddress.getLocalHost();
        String ip = addr.getHostAddress();
        Map<String, String> map = System.getenv();
        String userName = map.get("USERNAME");// 获取用户名
        String computerName = map.get("COMPUTERNAME");// 获取计算机名
        String userDomain = map.get("USERDOMAIN");// 获取计算机域名
        System.out.println("用户名:    " + userName);
        System.out.println("计算机名:    " + computerName);
        System.out.println("计算机域名:    " + userDomain);
        System.out.println("本地ip地址:    " + ip);
        System.out.println("本地主机名:    " + addr.getHostName());
        System.out.println("JVM可以使用的总内存:    " + r.totalMemory());
        System.out.println("JVM可以使用的剩余内存:    " + r.freeMemory());
        System.out.println("JVM可以使用的处理器个数:    " + r.availableProcessors());
        System.out.println("Java的运行环境版本：    " + props.getProperty("java.version"));
        System.out.println("Java的运行环境供应商：    " + props.getProperty("java.vendor"));
        System.out.println("Java供应商的URL：    " + props.getProperty("java.vendor.url"));
        System.out.println("Java的安装路径：    " + props.getProperty("java.home"));
        System.out.println("Java的虚拟机规范版本：    " + props.getProperty("java.vm.specification.version"));
        System.out.println("Java的虚拟机规范供应商：    " + props.getProperty("java.vm.specification.vendor"));
        System.out.println("Java的虚拟机规范名称：    " + props.getProperty("java.vm.specification.name"));
        System.out.println("Java的虚拟机实现版本：    " + props.getProperty("java.vm.version"));
        System.out.println("Java的虚拟机实现供应商：    " + props.getProperty("java.vm.vendor"));
        System.out.println("Java的虚拟机实现名称：    " + props.getProperty("java.vm.name"));
        System.out.println("Java运行时环境规范版本：    " + props.getProperty("java.specification.version"));
        System.out.println("Java运行时环境规范供应商：    " + props.getProperty("java.specification.vender"));
        System.out.println("Java运行时环境规范名称：    " + props.getProperty("java.specification.name"));
        System.out.println("Java的类格式版本号：    " + props.getProperty("java.class.version"));
        System.out.println("Java的类路径：    " + props.getProperty("java.class.path"));
        System.out.println("加载库时搜索的路径列表：    " + props.getProperty("java.library.path"));
        System.out.println("默认的临时文件路径：    " + props.getProperty("java.io.tmpdir"));
        System.out.println("一个或多个扩展目录的路径：    " + props.getProperty("java.ext.dirs"));
        System.out.println("操作系统的名称：    " + props.getProperty("os.name"));
        System.out.println("操作系统的构架：    " + props.getProperty("os.arch"));
        System.out.println("操作系统的版本：    " + props.getProperty("os.version"));
        System.out.println("文件分隔符：    " + props.getProperty("file.separator"));
        System.out.println("路径分隔符：    " + props.getProperty("path.separator"));
        System.out.println("行分隔符：    " + props.getProperty("line.separator"));
        System.out.println("用户的账户名称：    " + props.getProperty("user.name"));
        System.out.println("用户的主目录：    " + props.getProperty("user.home"));
        System.out.println("用户的当前工作目录：    " + props.getProperty("user.dir"));
    }

    public static long jvm(Sigar sigar) throws UnknownHostException {
        Runtime r = Runtime.getRuntime();
        return r.freeMemory() * 100 / r.totalMemory();
    }

    public static void memory() throws SigarException {
        Mem mem = sigar.getMem();
        // 内存总量
        System.out.println("内存总量:    " + mem.getTotal() / 1024L + "K av");
        // 当前内存使用量
        System.out.println("当前内存使用量:    " + mem.getUsed() / 1024L + "K used");
        // 当前内存剩余量
        System.out.println("当前内存剩余量:    " + mem.getFree() / 1024L + "K free");
        Swap swap = sigar.getSwap();
        // 交换区总量
        System.out.println("交换区总量:    " + swap.getTotal() / 1024L + "K av");
        // 当前交换区使用量
        System.out.println("当前交换区使用量:    " + swap.getUsed() / 1024L + "K used");
        // 当前交换区剩余量
        System.out.println("当前交换区剩余量:    " + swap.getFree() / 1024L + "K free");
    }

    public static long memory(Sigar sigar) throws SigarException {
        Mem mem = sigar.getMem();
        // 当前内存使用量
        return mem.getUsed() * 100 / mem.getTotal();
    }

    public static void cpu() throws SigarException {
        CpuInfo infos[] = sigar.getCpuInfoList();
        CpuPerc cpuList[] = null;
        cpuList = sigar.getCpuPercList();
        for (int i = 0; i < infos.length; i++) {// 不管是单块CPU还是多CPU都适用
            CpuInfo info = infos[i];
            System.out.println("第" + (i + 1) + "块CPU信息");
            System.out.println("CPU的总量MHz:    " + info.getMhz());// CPU的总量MHz
            System.out.println("CPU生产商:    " + info.getVendor());// 获得CPU的卖主，如：Intel
            System.out.println("CPU类别:    " + info.getModel());// 获得CPU的类别，如：Celeron
            System.out.println("CPU缓存数量:    " + info.getCacheSize());// 缓冲存储器数量
            printCpuPerc(cpuList[i]);
        }
    }

    public static void printCpuPerc(CpuPerc cpu) {
        System.out.println("CPU用户使用率:    " + CpuPerc.format(cpu.getUser()));// 用户使用率
        System.out.println("CPU系统使用率:    " + CpuPerc.format(cpu.getSys()));// 系统使用率
        System.out.println("CPU当前等待率:    " + CpuPerc.format(cpu.getWait()));// 当前等待率
        System.out.println("CPU当前错误率:    " + CpuPerc.format(cpu.getNice()));//
        System.out.println("CPU当前空闲率:    " + CpuPerc.format(cpu.getIdle()));// 当前空闲率
        System.out.println("CPU总的使用率:    " + CpuPerc.format(cpu.getCombined()));// 总的使用率
    }

    public static String cpu(Sigar sigar) throws SigarException {
        CpuPerc cpuList[] = null;
        cpuList = sigar.getCpuPercList();
        double combined = 0.0;
        for (int i = 0; i < cpuList.length; i++) {// 不管是单块CPU还是多CPU都适用
            combined += cpuList[i].getCombined();
        }
        combined = combined / cpuList.length;
        return cpuFormat(combined);
    }

    public static String cpuFormat(double val) {
        String p = String.valueOf(val * 100.0D);
        int ix = p.indexOf(".") + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent;
    }

    public static void os() {

        OperatingSystem OS = OperatingSystem.getInstance();
        // 操作系统内核类型如： 386、486、586等x86
        System.out.println("操作系统:    " + OS.getArch());
        System.out.println("操作系统CpuEndian():    " + OS.getCpuEndian());//
        System.out.println("操作系统DataModel():    " + OS.getDataModel());//
        // 系统描述
        System.out.println("操作系统的描述:    " + OS.getDescription());
        // 操作系统类型
        System.out.println("OS.getName():    " + OS.getName());
        System.out.println("OS.getPatchLevel():    " + OS.getPatchLevel());//
        // 操作系统的卖主
        System.out.println("操作系统的卖主:    " + OS.getVendor());
        // 卖主名称
        System.out.println("操作系统的卖主名:    " + OS.getVendorCodeName());
        // 操作系统名称
        System.out.println("操作系统名称:    " + OS.getVendorName());
        // 操作系统卖主类型
        System.out.println("操作系统卖主类型:    " + OS.getVendorVersion());
        // 操作系统的版本号
        System.out.println("操作系统的版本号:    " + OS.getVersion());
    }

    public static void who() throws SigarException {
        Who who[] = sigar.getWhoList();
        if (who != null && who.length > 0) {
            for (int i = 0; i < who.length; i++) {
                // System.out.println("当前系统进程表中的用户名" + String.valueOf(i));
                Who _who = who[i];
                System.out.println("用户控制台:    " + _who.getDevice());
                System.out.println("用户host:    " + _who.getHost());
                // System.out.println("getTime():    " + _who.getTime());
                // 当前系统进程表中的用户名
                System.out.println("当前系统进程表中的用户名:    " + _who.getUser());
            }
        }
    }

    public static void file() throws Exception {
        FileSystem fslist[] = sigar.getFileSystemList();
        try {
            for (int i = 0; i < fslist.length; i++) {
                System.out.println("分区的盘符名称" + i);
                FileSystem fs = fslist[i];
                // 分区的盘符名称
                System.out.println("盘符名称:    " + fs.getDevName());
                // 分区的盘符名称
                System.out.println("盘符路径:    " + fs.getDirName());
                System.out.println("盘符标志:    " + fs.getFlags());//
                // 文件系统类型，比如 FAT32、NTFS
                System.out.println("盘符类型:    " + fs.getSysTypeName());
                // 文件系统类型名，比如本地硬盘、光驱、网络文件系统等
                System.out.println("盘符类型名:    " + fs.getTypeName());
                // 文件系统类型
                System.out.println("盘符文件系统类型:    " + fs.getType());
                FileSystemUsage usage = null;
                usage = sigar.getFileSystemUsage(fs.getDirName());
                switch (fs.getType()) {
                    case 0: // TYPE_UNKNOWN ：未知
                        break;
                    case 1: // TYPE_NONE
                        break;
                    case 2: // TYPE_LOCAL_DISK : 本地硬盘
                        // 文件系统总大小
                        System.out.println(fs.getDevName() + "总大小:    " + usage.getTotal() + "KB");
                        // 文件系统剩余大小
                        System.out.println(fs.getDevName() + "剩余大小:    " + usage.getFree() + "KB");
                        // 文件系统可用大小
                        System.out.println(fs.getDevName() + "可用大小:    " + usage.getAvail() + "KB");
                        // 文件系统已经使用量
                        System.out.println(fs.getDevName() + "已经使用量:    " + usage.getUsed() + "KB");
                        double usePercent = usage.getUsePercent() * 100D;
                        // 文件系统资源的利用率
                        System.out.println(fs.getDevName() + "资源的利用率:    " + usePercent + "%");
                        break;
                    case 3:// TYPE_NETWORK ：网络
                        break;
                    case 4:// TYPE_RAM_DISK ：闪存
                        break;
                    case 5:// TYPE_CDROM ：光驱
                        break;
                    case 6:// TYPE_SWAP ：页面交换
                        break;
                }
                System.out.println(fs.getDevName() + "读出：    " + usage.getDiskReads());
                System.out.println(fs.getDevName() + "写入：    " + usage.getDiskWrites());
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }

        return;
    }

    public static String diskSpeed(Sigar sigar) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        try {
            FileSystemUsage sfileSystemUsage = null;
            FileSystemUsage efileSystemUsage = null;
            List<FileSystem> list = Arrays.asList(sigar.getFileSystemList());
            double startreads = 0;
            double startwrites = 0;

            double endreads = 0;
            double endwrites = 0;

            double reads = 0;
            double writes = 0;

            long start = System.currentTimeMillis();
            for (int i = 0; i < list.size(); i++) {
                try {
                    sfileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
                } catch (SigarException e) {// 当fileSystem.getType()为5时会出现该异常——此时文件系统类型为光驱
                    continue;
                }
                startreads += sfileSystemUsage.getDiskReads();
                startwrites += sfileSystemUsage.getDiskWrites();
            }

            Thread.sleep(1000);
            long end = System.currentTimeMillis();
            for (int i = 0; i < list.size(); i++) {
                try {
                    efileSystemUsage = sigar.getFileSystemUsage(String.valueOf(list.get(i)));
                } catch (SigarException e) {// 当fileSystem.getType()为5时会出现该异常——此时文件系统类型为光驱
                    continue;
                }

                endreads += efileSystemUsage.getDiskReads();
                endwrites += efileSystemUsage.getDiskWrites();
            }

            reads = ((endreads - startreads) * 8 / (end - start) * 1000);
            writes = ((endwrites - startwrites) * 8 / (end - start) * 1000);

            // 读
            String readss = String.format("%.1f", reads) + " KB/s";
            // 写
            String writess = String.format("%.1f", writes) + " KB/s";

            sb.append("\"readss\":\"").append(readss).append("\",");
            sb.append("\"writess\":\"").append(writess).append("\"");
        } catch (Exception e) {
            log.error("获取硬盘传输速度异常", e);
        }
        sb.append("}");

        return sb.toString();
    }

    public static long disk(Sigar sigar) throws Exception {
        long total = 0;
        long totalFree = 0;
        long totalPercent = 0;

        FileSystem fslist[] = sigar.getFileSystemList();
        for (int i = 0; i < fslist.length; i++) {
            FileSystem fs = fslist[i];
            FileSystemUsage usage = null;
            usage = sigar.getFileSystemUsage(fs.getDirName());
            switch (fs.getType()) {
                case 0: // TYPE_UNKNOWN ：未知
                    break;
                case 1: // TYPE_NONE
                    break;
                case 2: // TYPE_LOCAL_DISK : 本地硬盘
                    // 文件系统总大小
                    total += usage.getTotal();
                    // 文件系统剩余大小
                    totalFree += usage.getFree();
                    // 文件系统可用大小
                    // 文件系统已经使用量
                    double usePercent = usage.getUsePercent() * 100D;
                    // 文件系统资源的利用率
                    totalPercent += usePercent;
                    break;
                case 3:// TYPE_NETWORK ：网络
                    break;
                case 4:// TYPE_RAM_DISK ：闪存
                    break;
                case 5:// TYPE_CDROM ：光驱
                    break;
                case 6:// TYPE_SWAP ：页面交换
                    break;
            }
        }
        return totalPercent / fslist.length;
    }

    public static void net() throws Exception {
        String ifNames[] = sigar.getNetInterfaceList();
        System.out.println(ifNames.length);
        for (int i = 0; i < ifNames.length; i++) {
            String name = ifNames[i];
            NetInterfaceConfig ifconfig = sigar.getNetInterfaceConfig(name);
            System.out.println("网络设备名:    " + name);// 网络设备名
            System.out.println("IP地址:    " + ifconfig.getAddress());// IP地址
            System.out.println("子网掩码:    " + ifconfig.getNetmask());// 子网掩码
            if ((ifconfig.getFlags() & 1L) <= 0L) {
                System.out.println("!IFF_UP...skipping getNetInterfaceStat");
                continue;
            }
            NetInterfaceStat ifstat = sigar.getNetInterfaceStat(name);
//            System.out.println(name + "接收的总包裹数:" + ifstat.getRxPackets());// 接收的总包裹数
//            System.out.println(name + "发送的总包裹数:" + ifstat.getTxPackets());// 发送的总包裹数
//            System.out.println(name + "接收到的总字节数:" + ifstat.getRxBytes());// 接收到的总字节数
//            System.out.println(name + "发送的总字节数:" + ifstat.getTxBytes());// 发送的总字节数
//            System.out.println(name + "接收到的错误包数:" + ifstat.getRxErrors());// 接收到的错误包数
//            System.out.println(name + "发送数据包时的错误数:" + ifstat.getTxErrors());// 发送数据包时的错误数
//            System.out.println(name + "接收时丢弃的包数:" + ifstat.getRxDropped());// 接收时丢弃的包数
//            System.out.println(name + getDiskTempFromSmart"发送时丢弃的包数:" + ifstat.getTxDropped());// 发送时丢弃的包数
        }
    }

    public static String ethernet(Sigar sigar) throws SigarException {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int index = 0;
        try {
            String[] ifaces = sigar.getNetInterfaceList();
            for (int i = 0; i < ifaces.length; i++) {
                String iface = ifaces[i];
                NetInterfaceConfig cfg = sigar.getNetInterfaceConfig(iface);
                if (NetFlags.LOOPBACK_ADDRESS.equals(cfg.getAddress()) || (cfg.getFlags() & NetFlags.IFF_LOOPBACK) != 0
                        || NetFlags.NULL_HWADDR.equals(cfg.getHwaddr()) || NetFlags.ANY_ADDR.equals(cfg.getAddress())) {
                    continue;
                }
                if (index != 0) {
                    sb.append(",");
                }
                sb.append("{");
                sb.append("\"name\":\"").append(cfg.getName()).append("\",");  // name
                sb.append("\"address\":\"").append(cfg.getAddress()).append("\","); // IP地址
                sb.append("\"broadcast\":\"").append(cfg.getBroadcast()).append("\",");  // 网关广播地址
                sb.append("\"hwaddr\":\"").append(cfg.getHwaddr()).append("\",");  //  网卡MAC地址
                sb.append("\"netmask\":\"").append(cfg.getNetmask()).append("\","); // 子网掩码
                sb.append("\"description\":\"").append(cfg.getDescription()).append("\","); // 网卡描述信息
                sb.append("\"type\":\"").append(cfg.getType()).append("\","); // 类型

                NetInterfaceStat ifstat = sigar.getNetInterfaceStat(iface);
                sb.append("\"speed\":\"").append(ifstat.getSpeed()).append("\","); // 接收的总包裹数
                sb.append("\"rxPackets\":\"").append(ifstat.getRxPackets()).append("\","); // 接收的总包裹数
                sb.append("\"txPackets\":\"").append(ifstat.getTxPackets()).append("\","); // 发送的总包裹数
                sb.append("\"rxBytes\":\"").append(ifstat.getRxBytes()).append("\","); // 接收到的总字节数
                sb.append("\"txBytes\":\"").append(ifstat.getTxBytes()).append("\","); // 发送的总字节数
//                sb.append("\"rxErrors\":\"").append(ifstat.getRxErrors()).append("\","); // 接收到的错误包数
//                sb.append("\"txErrors\":\"").append(ifstat.getTxErrors()).append("\","); // 发送数据包时的错误数
//                sb.append("\"rxDropped\":\"").append(ifstat.getRxDropped()).append("\","); // 接收时丢弃的包数
//                sb.append("\"txDropped\":\"").append(ifstat.getTxDropped()).append("\""); // 发送时丢弃的包数


                double rxSpeedBytes = 0;
                double txSpeedBytes = 0;
                double start = System.currentTimeMillis();
                NetInterfaceStat statStart = sigar.getNetInterfaceStat(iface);
                double rxBytesStart = statStart.getRxBytes();
                double txBytesStart = statStart.getTxBytes();

                Thread.sleep(1000);
                double end = System.currentTimeMillis();
                NetInterfaceStat statEnd = sigar.getNetInterfaceStat(iface);
                double rxBytesEnd = statEnd.getRxBytes();
                double txBytesEnd = statEnd.getTxBytes();

                rxSpeedBytes = NumberUtil.round(((rxBytesEnd - rxBytesStart) * 8 / (end - start) * 1000) / 1024, 1).doubleValue();
                txSpeedBytes = NumberUtil.round(((txBytesEnd - txBytesStart) * 8 / (end - start) * 1000) / 1024, 1).doubleValue();

                sb.append("\"rxSpeedBytes\":\"").append(rxSpeedBytes).append("\","); // 接收网速
                sb.append("\"txSpeedBytes\":\"").append(txSpeedBytes).append("\""); // 发送网速

                sb.append("}");
                index++;
            }
        } catch (Exception e) {
            log.error("获取ethernet信息异常", e);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String ethernetSimple(Sigar sigar) throws SigarException {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int index = 0;
        try {
            String[] ifaces = sigar.getNetInterfaceList();
            for (int i = 0; i < ifaces.length; i++) {
                String iface = ifaces[i];
                NetInterfaceConfig cfg = sigar.getNetInterfaceConfig(iface);
                if (NetFlags.LOOPBACK_ADDRESS.equals(cfg.getAddress()) || (cfg.getFlags() & NetFlags.IFF_LOOPBACK) != 0
                        || NetFlags.NULL_HWADDR.equals(cfg.getHwaddr()) || NetFlags.ANY_ADDR.equals(cfg.getAddress())) {
                    continue;
                }
                if (index != 0) {
                    sb.append(",");
                }
                sb.append("{");
                sb.append("\"name\":\"").append(cfg.getName()).append("\",");  // name
                sb.append("\"hwaddr\":\"").append(cfg.getHwaddr()).append("\",");  //  网卡MAC地址
                sb.append("\"address\":\"").append(cfg.getAddress()).append("\""); // IP地址
                sb.append("}");
                index++;
            }
        } catch (Exception e) {
            log.error("获取ethernet信息异常", e);
        }
        sb.append("]");
        return sb.toString();
    }
}
