package com.priusis;

import com.priusis.client.service.TenantManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import javax.annotation.Resource;

@Slf4j
@EnableScheduling
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, SecurityAutoConfiguration.class})
public class ApqClientApplication implements ApplicationListener {

    public static void main(String[] args) {
        SpringApplication.run(ApqClientApplication.class, args);
    }

//    public static void main(String[] args) {
//        System.out.println(System.currentTimeMillis());
//    }

    @Resource
    private TenantManagerService service;

    @Scheduled(fixedDelay = 60000)
    protected void heartbeatJob() {
        try {
            service.processRequest("oc-client", "{\"heartbeat\":1}");
        } catch (Exception e) {
            log.error("发送心跳异常", e);
        }
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStoppedEvent || event instanceof ContextClosedEvent) { // 应用停止
            log.info("应用停止==================");
        }
    }
}
