package com.priusis.utils;

import com.sun.jna.NativeLibrary;
import com.sun.jna.ptr.IntByReference;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;


/**
 * Java通过JNA调用CoreTemp.dll实现温度采集
 * https://github.com/boyang987/BLHWScaner
 */
@Slf4j
public class CoreTempUtil {

//    static final String coreFromOs = "CoreTemp" + (OshiUtil.getOs().getBitness() == 64 ? "x64" : "");
//    static final String WR0_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/" + coreFromOs + ".dll", System.getProperty("user.dir") + "/apq-pc-common");
    static final String WR0_DLL_NAME = ParseUrlUtil.parseAbsolutePath("/core/CoreTemp.dll", System.getProperty("user.dir") + "/apq-pc-common");

    /**
     * CPU温度
     */
    public static int[] getCpuAndGpuTemp() throws Exception {
        NativeLibrary instance = null;
        int[] cpuAndGpuTemp = new int[2];
        try {
            instance = NativeLibrary.getInstance(WR0_DLL_NAME);
            IntByReference cpuCoreNum = new IntByReference(0);

            int[] cpuTemp = new int[64];
            int[] gpuTemp = new int[64];
            //WinRing0初始化
            instance.getFunction("GetCpuTemp").invoke(new Object[]{cpuCoreNum, cpuTemp});
            int cpuTempV = Arrays.stream(cpuTemp).max().getAsInt();
            instance.getFunction("GetGpuTemp").invoke(new Object[]{cpuCoreNum, gpuTemp});
            int gpuTempV = Arrays.stream(gpuTemp).max().getAsInt();
            cpuAndGpuTemp[0] = cpuTempV;
            cpuAndGpuTemp[1] = gpuTempV;
            return cpuAndGpuTemp;

        } catch (Throwable e) {
            log.error("获取CPU温度异常", e);
            cpuAndGpuTemp[0] = 0;
            cpuAndGpuTemp[1] = 0;
            return cpuAndGpuTemp;
        } finally {
            if (null != instance) {
                WinRing0Util.doDeinitializeOls();
                instance.dispose();
                instance = null;
            }
        }
    }

    /**
     * CPU温度
     */
    public static int getCpuTemp() throws Exception {
        NativeLibrary instance = null;
        try {
            instance = NativeLibrary.getInstance(WR0_DLL_NAME);
            IntByReference cpuCoreNum = new IntByReference(0);
            int[] cpuTemp = new int[64];
            //WinRing0初始化
            instance.getFunction("GetCpuTemp").invoke(new Object[]{cpuCoreNum, cpuTemp});
            return Arrays.stream(cpuTemp).max().getAsInt();
        } catch (Exception e) {
            log.error("获取CPU温度异常", e);
            return 0;
        } finally {
            if (null != instance) {
                WinRing0Util.doDeinitializeOls();
                instance.dispose();
                instance = null;
                System.gc();
            }
        }
    }

    /**
     * GPU温度
     */
    public static int getGpuTemp() throws Exception {
        NativeLibrary instance = null;
        try {
            instance = NativeLibrary.getInstance(WR0_DLL_NAME);
            IntByReference pSensorNum = new IntByReference(0);
            int[] gpuTemp = new int[64];
            instance.getFunction("GetGpuTemp").invoke(new Object[]{pSensorNum, gpuTemp});

            return Arrays.stream(gpuTemp).max().getAsInt();
        } catch (Exception e) {
            log.error("GPU温度", e);
            return 0;
        } finally {
            if (null != instance) {
                WinRing0Util.doDeinitializeOls();
                instance.dispose();
                instance = null;
            }
        }
    }

    /**
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception {
        /*while (true) {
            NativeLibrary instance = NativeLibrary.getInstance(WR0_DLL_NAME);
            IntByReference cpuCoreNum = new IntByReference(0);
            int[] cpuTemp = new int[64];
            //WinRing0初始化
            instance.getFunction("GetCpuTemp").invoke(new Object[]{cpuCoreNum, cpuTemp});

            int value = cpuCoreNum.getValue();
            System.out.println(value);
            for (int i = 0; i < value; i++) {
                System.out.println(cpuTemp[i]);
            }

            IntByReference pSensorNum = new IntByReference(0);
            int[] gpuTemp = new int[64];
            instance.getFunction("GetGpuTemp").invoke(new Object[]{pSensorNum, gpuTemp});

            System.out.println("CPU温度:" + Arrays.stream(cpuTemp).max().getAsInt()); // cpu温度
            System.out.println("GPU温度:" + Arrays.stream(gpuTemp).max().getAsInt()); // gpu温度

            instance.dispose();
            System.out.println("===============================");
            Thread.sleep(1500);
        }*/

        while (true) {
            int[] cpuAndGpuTemp = CoreTempUtil.getCpuAndGpuTemp();
            System.out.println(cpuAndGpuTemp[0]);
            System.out.println(cpuAndGpuTemp[1]);
            System.out.println("===============================");
            Thread.sleep(1500);
        }

    }
}
