package com.priusis.utils;

import com.sun.jna.Platform;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ParseUrlUtil {
    /**
     * @param relatePath 相对路径 /qr/dat/
     * @return
     */
    static String parseAbsolutePath(String relatePath, String defaultPath) {
        String path = defaultPath;

        if (Platform.isWindows()) {
            path = IHwPortController.class.getResource(relatePath).getPath();
            if (path.contains("BOOT-INF")) {
                path = System.getProperty("user.dir") + "/" + relatePath;
            }
            path = path.replaceFirst("/", "");//排除中文空格
            path = path.replaceAll("%20", " ");//排除中文空格
            path = path.replaceAll("/", "\\\\");//排除中文空格
            try {
                path = java.net.URLDecoder.decode(path, "utf-8"); //解决路径包含中文的情况
                log.info("解析到PATH为:{}", path);
            } catch (Exception e) {
                log.error("usr decode", e);
                path = defaultPath;
            }
        }
        //if (Platform.isLinux()) {
        //    try {
        //        ApplicationHome h = new ApplicationHome(IHwPortController.class);
        //        File jarF = h.getSource();
        //        path = jarF.getParentFile().toString() + relatePath;
        //    } catch (Exception e) {
        //        path = "/app/smart-property/qr/dll";
        //    }
        //}

        return path;
    }
}
