package com.priusis.util;

import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

import java.awt.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

@Slf4j
public class WinExecuteUtils {

    /**
     * @desc 启动进程
     * @author zp
     * @date 2018-3-29
     */
    public static void startProc(String processName) {
        log.info("启动应用程序：" + processName);
        if (StrUtil.isNotBlank(processName)) {
            try {
                Desktop.getDesktop().open(new File(processName));
            } catch (Exception e) {
                e.printStackTrace();
                log.error("应用程序：" + processName + "不存在！");
            }
        }
    }

    /**
     * @throws IOException
     * @desc 杀死进程
     * @author zp
     * @date 2018-3-29
     */
    public static void killProc(String processName) throws IOException {
        log.info("关闭应用程序：" + processName);
        if (StrUtil.isNotBlank(processName)) {
            executeCmd("taskkill /F /IM " + processName);
        }
    }

    /**
     * @desc 执行cmd命令
     * @author zp
     * @date 2018-3-29
     */
    public static String executeCmd(String command) throws IOException {
        log.info("Execute command : " + command);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("cmd /c " + command);
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
        String line = null;
        StringBuilder build = new StringBuilder();
        while ((line = br.readLine()) != null) {
            log.info(line);
            build.append(line);
        }
        return build.toString();
    }

    /**
     * @desc 判断进程是否开启
     * @author zp
     * @date 2018-3-29
     */
    public static boolean findProcess(String processName) {
        BufferedReader bufferedReader = null;
        try {
            Process proc = Runtime.getRuntime().exec("tasklist -fi " + '"' + "imagename eq " + processName + '"');
            bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains(processName)) {
                    return true;
                }
            }
            return false;
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        } finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (Exception ex) {
                }
            }
        }
    }


    public static void main(String[] args) {
        String procName = "Postman.exe";
        boolean exist = findProcess(procName);
        try {
            if (exist) {
                // 存在，那么就先杀死该进程
                killProc(procName);
                // 再启动
                startProc(procName);
            } else {
                startProc(procName);
            }
        } catch (Exception e) {
            // TODO: handle exception
            log.error("重启/杀死提取程序失败。。。");
        }
    }

}
