package com.priusis;

import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.system.oshi.OshiUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.client.RestTemplate;
import oshi.hardware.NetworkIF;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest
public class RestTest {

    @Autowired
    private RestTemplate restTemplate;

    @Test
    public void test1() throws Exception {
        /*Map<String, Object> data = new HashMap<>();
        // {
        //    "device": "101",
        //    "lat": "210.2",
        //    "lng": "11.21"
        //}
        data.put("device", "101");
        data.put("lat", 210.2);
        data.put("lng", 11.21);*/

        InetAddress inetAddress = InetAddress.getLocalHost();
        NetworkIF networkIF = new NetworkIF();
        networkIF.setNetworkInterface(NetworkInterface.getByInetAddress(inetAddress));
        Map<String, Object> data = MapUtil.<String, Object>builder()
                .put("operatingSystem", OshiUtil.getOs().toString())
                .put("mac", networkIF.getMacaddr())
                .put("baseboard", OshiUtil.getSystem().getBaseboard().getManufacturer() + " " + OshiUtil.getSystem().getBaseboard().getVersion())
                .put("ip", inetAddress.getHostAddress())
                .put("cpuModel", OshiUtil.getCpuInfo(0).getCpuModel())
                .put("cpuTemp", OshiUtil.getSensors().getCpuTemperature())
                .put("memoryCap", DataSizeUtil.format(OshiUtil.getMemory().getTotal()))
                .put("diskModel", OshiUtil.getHardware().getDiskStores()[0].getModel())
                .put("diskCap", DataSizeUtil.format(OshiUtil.getHardware().getDiskStores()[0].getSize()))
                .build();
        Map map = restTemplate.postForObject("http://localhost:9090/uplink/oc-client", data, Map.class);
        System.out.println(map);
    }
}
