package com.priusis.utils.sigar;

import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

/**
 * 获取系统内存信息
 */
public class SigarGetMen {

    public static void main(String[] args) throws SigarException {

        // 使用sigar获取CPU信息及内存
        Sigar sigar = new Sigar();
        double memTotal = sigar.getMem().getTotal();
        double memRam = sigar.getMem().getRam();
        double memUsed = sigar.getMem().getActualUsed();// mem
        double memFree = sigar.getMem().getActualFree();
        double memUsedPerc = sigar.getMem().getUsedPercent();

        String memory = String.format("%.0f", memTotal / 1024 / 1024 / 1024) + " GB";
        String memRamStr = String.format("%.1f", memRam / 1024) + " GB";
        String memused = String.format("%.2f", memUsed / 1024 / 1024 / 1024) + " GB";
        String memFrees = String.format("%.2f", memFree / 1024 / 1024 / 1024) + " GB";
        String memoryUsage = String.format("%.2f", memUsedPerc) + " %";


        System.out.println("内存=======" + memory);
        System.out.println("内存使用量=======" + memRamStr);
        System.out.println("使用中=======" + memused);
        System.out.println("可用=======" + memFrees);
        System.out.println("内存使用率=======" + memoryUsage);

        // 关闭sigar
        sigar.close();

    }

}
